/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFException;
import org.jppf.client.JPPFJob;
import org.jppf.client.concurrent.ExecutorServiceConfiguration;
import org.jppf.client.concurrent.ExecutorServiceConfigurationImpl;
import org.jppf.client.concurrent.FutureResultCollector;
import org.jppf.client.concurrent.JPPFExecutorService;
import org.jppf.client.concurrent.JPPFTaskFuture;
import org.jppf.client.concurrent.JobConfiguration;
import org.jppf.client.concurrent.TaskConfiguration;
import org.jppf.client.event.JobListener;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.Pair;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchHandler
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(BatchHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static AtomicLong jobCount = new AtomicLong(0L);
    private static final ExecutorServiceConfiguration DEFAULT_CONFIG = new ExecutorServiceConfigurationImpl();
    private int batchSize = 0;
    private long batchTimeout = 0L;
    private JPPFExecutorService executor = null;
    private AtomicReference<JPPFJob> currentJobRef = new AtomicReference<Object>(null);
    private AtomicReference<JPPFJob> nextJobRef = new AtomicReference<Object>(null);
    private long start = 0L;
    private long elapsed = 0L;
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition jobReady = this.lock.newCondition();
    private Condition submittingJob = this.lock.newCondition();
    private ExecutorServiceConfiguration config = new ExecutorServiceConfigurationImpl();

    BatchHandler(JPPFExecutorService executor) {
        this.executor = executor;
        this.nextJobRef.set(this.createJob());
    }

    synchronized int getBatchSize() {
        return this.batchSize;
    }

    synchronized void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    synchronized long getBatchTimeout() {
        return this.batchTimeout;
    }

    synchronized void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.start = System.currentTimeMillis();
        while (!this.isStopped()) {
            try {
                this.lock.lock();
                try {
                    while (!this.isStopped() && this.currentJobRef.get() == null) {
                        if (this.batchTimeout > 0L) {
                            long n = this.batchTimeout - this.elapsed;
                            if (n > 0L) {
                                this.jobReady.await(n, TimeUnit.MILLISECONDS);
                            }
                        } else {
                            this.jobReady.await();
                        }
                        this.updateNextJob(false);
                    }
                    if (this.isStopped()) break;
                    JPPFJob job = this.currentJobRef.get();
                    if (debugEnabled) {
                        log.debug("submitting job " + job.getName() + " with " + job.getTasks().size() + " tasks");
                    }
                    FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
                    this.configureJob(job);
                    this.executor.submitJob(job);
                    this.currentJobRef.set(null);
                    this.elapsed = System.currentTimeMillis() - this.start;
                    this.submittingJob.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateNextJob(boolean sendSignal) {
        JPPFJob job = this.nextJobRef.get();
        int size = job.getTasks().size();
        if (this.batchTimeout > 0L) {
            this.elapsed = System.currentTimeMillis() - this.start;
        }
        if (size == 0) {
            if (this.batchTimeout > 0L && this.elapsed >= this.batchTimeout) {
                this.resetTimeout();
            }
            return;
        }
        if (this.batchTimeout > 0L && this.elapsed >= this.batchTimeout || this.batchSize > 0 && size >= this.batchSize || this.batchSize <= 0 && this.batchTimeout <= 0L) {
            this.currentJobRef.set(job);
            this.nextJobRef.set(this.createJob());
            this.resetTimeout();
            if (sendSignal) {
                this.jobReady.signal();
                try {
                    this.submittingJob.await();
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        }
    }

    private void resetTimeout() {
        this.start = System.currentTimeMillis();
        this.elapsed = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(JPPFTask task, T result) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting one JPPFTask");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
                job.addTask(task, new Object[0]);
                future = new JPPFTaskFuture(collector, task.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(Runnable task, T result) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting one Runnable task with result");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
                JPPFAnnotatedTask t = (JPPFAnnotatedTask)job.addTask(task, new Object[0]);
                t.setResult(result);
                this.configureTask(t);
                future = new JPPFTaskFuture(collector, t.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(Callable<T> task) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting one Callable Task");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
                JPPFAnnotatedTask jppfTask = (JPPFAnnotatedTask)job.addTask(task, new Object[0]);
                this.configureTask(jppfTask);
                future = new JPPFTaskFuture(collector, jppfTask.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Pair<FutureResultCollector, Integer> addTasks(Collection<? extends Callable<T>> tasks) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting " + tasks.size() + " Callable Tasks");
            }
            Pair pair = null;
            JPPFJob job = this.nextJobRef.get();
            FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
            int start = 0;
            try {
                List<JPPFTask> jobTasks = job.getTasks();
                start = jobTasks.size();
                for (Callable<T> task : tasks) {
                    JPPFTask t = job.addTask(task, new Object[0]);
                    this.configureTask((JPPFAnnotatedTask)t);
                }
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            pair = new Pair((Object)collector, (Object)start);
            this.updateNextJob(true);
            Pair pair2 = pair;
            return pair2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private JPPFJob createJob() {
        JPPFJob job = new JPPFJob();
        job.setName(this.getClass().getSimpleName() + " job " + jobCount.incrementAndGet());
        FutureResultCollector collector = new FutureResultCollector(job);
        job.setResultListener(collector);
        job.setBlocking(false);
        collector.addListener(this.executor);
        if (debugEnabled) {
            log.debug("created job " + job);
        }
        return job;
    }

    private synchronized void configureJob(JPPFJob job) {
        if (this.config != null) {
            JobConfiguration jc = this.config.getJobConfiguration();
            job.setSLA(jc.getSLA());
            job.setClientSLA(jc.getClientSLA());
            job.setMetadata(jc.getMetadata());
            job.setPersistenceManager(jc.getPersistenceManager());
            job.setDataProvider(jc.getDataProvider());
            for (JobListener listener : jc.getAllJobListeners()) {
                job.addJobListener(listener);
            }
        }
    }

    private synchronized void configureTask(JPPFAnnotatedTask task) {
        if (this.config != null) {
            TaskConfiguration tc = this.config.getTaskConfiguration();
            task.setCancelCallback(tc.getOnCancelCallback());
            task.setTimeoutCallback(tc.getOnTimeoutCallback());
            task.setTimeoutSchedule(tc.getTimeoutSchedule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.setStopped(true);
        this.lock.lock();
        try {
            this.jobReady.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized ExecutorServiceConfiguration getConfig() {
        return this.config;
    }

    synchronized void setConfig(ExecutorServiceConfiguration config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.config = config;
    }

    synchronized ExecutorServiceConfiguration resetConfig() {
        this.config = new ExecutorServiceConfigurationImpl();
        return this.config;
    }
}

