/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.LinkedList;
import java.util.List;
import org.jppf.client.concurrent.JobConfiguration;
import org.jppf.client.event.JobListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.protocol.JPPFJobClientSLA;
import org.jppf.server.protocol.JPPFJobMetadata;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.task.storage.DataProvider;

abstract class AbstractJobConfiguration
implements JobConfiguration {
    protected JobSLA jobSLA = new JPPFJobSLA();
    protected JobClientSLA jobClientSLA = new JPPFJobClientSLA();
    protected JobMetadata jobMetadata = new JPPFJobMetadata();
    protected JobPersistence<?> persistenceManager = null;
    protected DataProvider dataProvider = null;
    protected List<JobListener> listeners = new LinkedList<JobListener>();

    protected AbstractJobConfiguration() {
    }

    @Override
    public JobSLA getSLA() {
        return this.jobSLA;
    }

    public void setSLA(JobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    @Override
    public JobClientSLA getClientSLA() {
        return this.jobClientSLA;
    }

    public void setClientSLA(JobClientSLA jobClientSLA) {
        this.jobClientSLA = jobClientSLA;
    }

    @Override
    public JobMetadata getMetadata() {
        return this.jobMetadata;
    }

    public void setMetadata(JobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    @Override
    public <T> JobPersistence<T> getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public <T> void setPersistenceManager(JobPersistence<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobListener> getAllJobListeners() {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            return this.listeners;
        }
    }
}

