/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.event.JobEvent;
import org.jppf.execute.ExecutorChannel;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.utils.PropertiesCollection;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientJob {
    private static final Logger log = LoggerFactory.getLogger(ClientJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    protected static final int NEW = 0;
    protected static final int EXECUTING = 1;
    protected static final int DONE = 2;
    protected static final int CANCELLED = 3;
    private volatile int status = 0;
    private final List<Runnable> onDoneList = new ArrayList<Runnable>();
    private long jobReceivedTime = 0L;
    private transient long queueEntryTime = 0L;
    protected final JPPFJob job;
    private String uuid = null;
    private String name = null;
    private JobSLA sla = null;
    private JobClientSLA clientSla = null;
    private JobMetadata metadata = null;
    private boolean jobExpired = false;
    private boolean pending = false;
    private final AtomicInteger channelsCount = new AtomicInteger(0);

    protected AbstractClientJob(JPPFJob job) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (debugEnabled) {
            log.debug("creating ClientJob #" + INSTANCE_COUNT.incrementAndGet());
        }
        this.job = job;
        this.uuid = this.job.getUuid();
        this.name = this.job.getName();
        this.sla = this.job.getSLA();
        this.clientSla = this.job.getClientSLA();
        this.metadata = this.job.getMetadata();
    }

    public JPPFJob getJob() {
        return this.job;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobSLA getSLA() {
        return this.sla;
    }

    public JobClientSLA getClientSLA() {
        return this.clientSla;
    }

    public JobMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JobMetadata metadata) {
        this.metadata = metadata;
    }

    public void setSLA(JobSLA sla) {
        this.sla = sla;
    }

    public void setClientSLA(JobClientSLA clientSla) {
        this.clientSla = clientSla;
    }

    public boolean isJobExpired() {
        return this.jobExpired;
    }

    public void jobExpired() {
        this.jobExpired = true;
        this.cancel(true);
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    protected final boolean updateStatus(int expect, int newStatus) {
        if (this.status == expect) {
            if (newStatus == 1 && this.status != newStatus) {
                this.job.fireJobEvent(JobEvent.Type.JOB_START, null, null);
            } else if (newStatus >= 2) {
                this.job.fireJobEvent(JobEvent.Type.JOB_END, null, null);
            }
            this.status = newStatus;
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.status >= 1;
    }

    public boolean isCancelled() {
        return this.status >= 3;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.status > 1) {
            return false;
        }
        this.status = 3;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        Runnable[] runnables;
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            runnables = this.onDoneList.toArray(new Runnable[this.onDoneList.size()]);
        }
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.remove(runnable);
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    public void addChannel(ExecutorChannel channel) {
        this.channelsCount.incrementAndGet();
    }

    public void removeChannel(ExecutorChannel channel) {
        this.channelsCount.decrementAndGet();
    }

    public boolean acceptsChannel(ExecutorChannel channel) {
        if (debugEnabled) {
            log.debug(StringUtils.build((Object[])new Object[]{"job '", this.getName(), "' : ", "pending=", this.isPending(), ", expired=", this.isJobExpired()}));
        }
        if (this.isPending()) {
            return false;
        }
        if (this.isJobExpired()) {
            return false;
        }
        if (this.channelsCount.get() >= this.clientSla.getMaxChannels()) {
            return false;
        }
        ExecutionPolicy policy = this.clientSla.getExecutionPolicy();
        boolean b = true;
        if (policy != null) {
            JPPFSystemInformation info = channel.getSystemInformation();
            b = policy.accepts((PropertiesCollection)info);
            if (debugEnabled) {
                log.debug("policy result = " + b);
            }
        }
        return b;
    }

    public void clearChannels() {
        this.channelsCount.set(0);
    }
}

