/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jppf.client.JPPFContextClient;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.client.balancer.stats.JPPFClientStatsManager;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorStatus;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.queue.JPPFQueue;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.JPPFContext;
import org.jppf.server.scheduler.bundle.JobAwareness;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.fixedsize.FixedSizeBundler;
import org.jppf.server.scheduler.bundle.fixedsize.FixedSizeProfile;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueueChecker<T extends ExecutorChannel>
extends ThreadSynchronization
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TaskQueueChecker.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private static final boolean traceEnabled = log.isTraceEnabled();
    private final Random random = new Random(System.nanoTime());
    private final JPPFPriorityQueue queue;
    private final JPPFClientStatsManager statsManager;
    private final Lock queueLock;
    private final Set<T> idleChannels = new LinkedHashSet<T>();
    private Bundler bundler;
    private final JPPFContext jppfContext;

    public TaskQueueChecker(JPPFPriorityQueue queue, JPPFClientStatsManager statsManager) {
        this.queue = queue;
        this.jppfContext = new JPPFContextClient((JPPFQueue)queue);
        this.statsManager = statsManager;
        this.queueLock = queue.getLock();
        this.bundler = this.createDefault();
    }

    public JPPFContext getJPPFContext() {
        return this.jppfContext;
    }

    protected Bundler createDefault() {
        FixedSizeProfile profile = new FixedSizeProfile();
        profile.setSize(1);
        return new FixedSizeBundler((LoadBalancingProfile)profile);
    }

    public Bundler getBundler() {
        return this.bundler;
    }

    public void setBundler(Bundler bundler) {
        this.bundler = bundler == null ? this.createDefault() : bundler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbIdleChannels() {
        Set<T> set = this.idleChannels;
        synchronized (set) {
            return this.idleChannels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleChannel(T channel) {
        int count;
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (channel.getExecutionStatus() != ExecutorStatus.ACTIVE) {
            throw new IllegalStateException("channel is not active: " + channel);
        }
        if (traceEnabled) {
            log.trace("Adding idle channel " + channel);
        }
        Set<T> set = this.idleChannels;
        synchronized (set) {
            this.idleChannels.add(channel);
            count = this.idleChannels.size();
        }
        this.wakeUp();
        this.statsManager.idleNodes(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getIdleChannels() {
        Set<T> set = this.idleChannels;
        synchronized (set) {
            return new ArrayList<T>(this.idleChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeIdleChannel(T channel) {
        int count;
        if (traceEnabled) {
            log.trace("Removing idle channel " + channel);
        }
        Set<T> set = this.idleChannels;
        synchronized (set) {
            this.idleChannels.remove(channel);
            count = this.idleChannels.size();
        }
        this.statsManager.idleNodes(count);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIdleChannel() {
        Set<T> set = this.idleChannels;
        synchronized (set) {
            return !this.idleChannels.isEmpty();
        }
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            if (this.dispatch()) continue;
            this.goToSleep(10L, 10000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch() {
        boolean dispatched = false;
        try {
            this.queue.processPendingBroadcasts();
            Set<T> set = this.idleChannels;
            synchronized (set) {
                if (this.idleChannels.isEmpty() || this.queue.isEmpty()) {
                    return false;
                }
                if (debugEnabled) {
                    log.debug(Integer.toString(this.idleChannels.size()) + " channels idle");
                }
                T channel = null;
                ClientJob selectedBundle = null;
                this.queueLock.lock();
                try {
                    Iterator it = this.queue.iterator();
                    while (channel == null && it.hasNext() && !this.idleChannels.isEmpty()) {
                        ClientJob bundleWrapper = (ClientJob)it.next();
                        channel = this.retrieveChannel(bundleWrapper);
                        if (channel == null) continue;
                        selectedBundle = bundleWrapper;
                    }
                    if (debugEnabled) {
                        log.debug(channel == null ? "no channel found for bundle" : "channel found for bundle: " + channel);
                    }
                    if (channel != null) {
                        this.dispatchJobToChannel(channel, selectedBundle);
                        dispatched = true;
                    }
                }
                catch (Exception ex) {
                    log.error("An error occurred while attempting to dispatch task bundles. This is most likely due to an error in the load balancer implementation.", (Throwable)ex);
                }
                finally {
                    this.queueLock.unlock();
                }
            }
        }
        catch (Exception ex) {
            log.error("An error occurred while preparing for bundle creation and dispatching.", (Throwable)ex);
        }
        return dispatched;
    }

    private T retrieveChannel(ClientJob bundleWrapper) throws Exception {
        return this.findIdleChannelIndex(bundleWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchJobToChannel(T channel, ClientJob selectedBundle) {
        if (debugEnabled) {
            log.debug("dispatching jobUuid=" + selectedBundle.getJob().getUuid() + " to channel " + channel + ", connectionUuid=" + channel.getConnectionUuid());
        }
        Object object = channel.getMonitor();
        synchronized (object) {
            int size = 1;
            try {
                this.updateBundler(this.getBundler(), selectedBundle.getJob(), channel);
                size = channel.getBundler().getBundleSize();
            }
            catch (Exception e) {
                log.error("Error in load balancer implementation, switching to 'manual' with a bundle size of 1", (Throwable)e);
                FixedSizeProfile profile = new FixedSizeProfile();
                profile.setSize(1);
                this.setBundler((Bundler)new FixedSizeBundler((LoadBalancingProfile)profile));
            }
            ClientTaskBundle bundleWrapper = this.queue.nextBundle(selectedBundle, size);
            selectedBundle.addChannel((ExecutorChannel)channel);
            channel.submit((Object)bundleWrapper);
        }
    }

    private T findIdleChannelIndex(ClientJob bundle) {
        int idleChannelsSize = this.idleChannels.size();
        ArrayList<ExecutorChannel> acceptableChannels = new ArrayList<ExecutorChannel>(idleChannelsSize);
        Iterator<T> iterator = this.idleChannels.iterator();
        while (iterator.hasNext()) {
            ExecutorChannel ch = (ExecutorChannel)iterator.next();
            if (ch.getExecutionStatus() != ExecutorStatus.ACTIVE) {
                if (debugEnabled) {
                    log.debug("channel is not opened: " + ch);
                }
                iterator.remove();
                continue;
            }
            if (!bundle.acceptsChannel(ch) || bundle.getBroadcastUUID() != null && !bundle.getBroadcastUUID().equals(ch.getUuid())) continue;
            acceptableChannels.add(ch);
        }
        int size = acceptableChannels.size();
        if (debugEnabled) {
            log.debug("found " + size + " acceptable channels");
        }
        if (size > 0) {
            return (T)((ExecutorChannel)acceptableChannels.get(size > 1 ? this.random.nextInt(size) : 0));
        }
        return null;
    }

    private void updateBundler(Bundler bundler, JPPFJob taskBundle, T context) {
        context.checkBundler(bundler, this.jppfContext);
        if (context.getBundler() instanceof JobAwareness) {
            JobMetadata metadata = taskBundle.getMetadata();
            ((JobAwareness)context.getBundler()).setJobMetadata(metadata);
        }
    }
}

