/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import org.jppf.client.balancer.ClientJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobExpirationAction
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JobExpirationAction.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final ClientJob bundleWrapper;

    public JobExpirationAction(ClientJob bundleWrapper) {
        if (bundleWrapper == null) {
            throw new IllegalArgumentException("bundleWrapper is null");
        }
        this.bundleWrapper = bundleWrapper;
    }

    @Override
    public void run() {
        String jobId = this.bundleWrapper.getName();
        try {
            if (debugEnabled) {
                log.debug("job '" + jobId + "' is expiring");
            }
            this.bundleWrapper.jobExpired();
        }
        catch (Exception e) {
            log.error("Error while cancelling job id = " + jobId, (Throwable)e);
        }
    }
}

