/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.SubmissionManagerClient;
import org.jppf.client.balancer.queue.JobExpirationAction;
import org.jppf.client.balancer.queue.JobPriorityComparator;
import org.jppf.client.balancer.queue.JobScheduleAction;
import org.jppf.client.submission.SubmissionStatus;
import org.jppf.execute.ExecutorStatus;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.node.protocol.JobSLA;
import org.jppf.queue.AbstractJPPFQueue;
import org.jppf.queue.JPPFQueue;
import org.jppf.queue.QueueEvent;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.scheduling.JPPFScheduleHandler;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.utils.CollectionUtils;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.collections.AbstractCollectionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPriorityQueue
extends AbstractJPPFQueue<ClientJob, ClientJob, ClientTaskBundle> {
    private static final Logger log = LoggerFactory.getLogger(JPPFPriorityQueue.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final SubmissionManagerClient submissionManager;
    private final JPPFScheduleHandler jobScheduleHandler = new JPPFScheduleHandler("Job Schedule Handler");
    private final JPPFScheduleHandler jobExpirationHandler = new JPPFScheduleHandler("Job Expiration Handler");
    private final PriorityBlockingQueue<ClientJob> pendingBroadcasts = new PriorityBlockingQueue<ClientJob>(16, new JobPriorityComparator());

    public JPPFPriorityQueue(SubmissionManagerClient submissionManager) {
        this.submissionManager = submissionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundle(final ClientJob bundleWrapper) {
        JobSLA sla = bundleWrapper.getSLA();
        final String jobUuid = bundleWrapper.getUuid();
        if (sla.isBroadcastJob() && bundleWrapper.getBroadcastUUID() == null) {
            if (debugEnabled) {
                log.debug("before processing broadcast job " + bundleWrapper.getJob());
            }
            this.processBroadcastJob(bundleWrapper);
        } else {
            this.lock.lock();
            try {
                ClientJob other = (ClientJob)this.jobMap.get(jobUuid);
                if (other != null) {
                    throw new IllegalStateException("Job " + jobUuid + " already enqueued");
                }
                bundleWrapper.addOnDone(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JPPFPriorityQueue.this.lock.lock();
                        try {
                            JPPFPriorityQueue.this.jobMap.remove(jobUuid);
                            JPPFPriorityQueue.this.removeBundle(bundleWrapper);
                        }
                        finally {
                            JPPFPriorityQueue.this.lock.unlock();
                        }
                    }
                });
                bundleWrapper.setSubmissionStatus(SubmissionStatus.PENDING);
                bundleWrapper.setQueueEntryTime(System.currentTimeMillis());
                bundleWrapper.setJobReceivedTime(bundleWrapper.getQueueEntryTime());
                if (!sla.isBroadcastJob() || bundleWrapper.getBroadcastUUID() != null) {
                    this.priorityMap.putValue((Object)sla.getPriority(), (Object)bundleWrapper);
                    this.sizeMap.putValue((Object)this.getSize(bundleWrapper), (Object)bundleWrapper);
                    if (debugEnabled) {
                        log.debug("adding bundle with " + bundleWrapper);
                    }
                    this.handleStartJobSchedule(bundleWrapper);
                    this.handleExpirationJobSchedule(bundleWrapper);
                }
                this.jobMap.put(jobUuid, bundleWrapper);
                this.updateLatestMaxSize();
                this.fireQueueEvent(new QueueEvent((JPPFQueue)this, (Object)bundleWrapper, false));
                if (debugEnabled) {
                    log.debug("Maps size information: " + CollectionUtils.formatSizeMapInfo((String)"priorityMap", (AbstractCollectionMap)this.priorityMap) + " - " + CollectionUtils.formatSizeMapInfo((String)"sizeMap", (AbstractCollectionMap)this.sizeMap));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeue(ClientJob job) {
        this.lock.lock();
        try {
            if (!this.jobMap.containsKey(job.getUuid())) {
                throw new IllegalStateException("Job not managed");
            }
            this.priorityMap.putValue((Object)job.getSLA().getPriority(), (Object)job);
            this.sizeMap.putValue((Object)this.getSize(job), (Object)job);
            this.fireQueueEvent(new QueueEvent((JPPFQueue)this, (Object)job, true));
        }
        finally {
            this.lock.unlock();
        }
    }

    public ClientTaskBundle nextBundle(int nbTasks) {
        Iterator it = this.iterator();
        return it.hasNext() ? this.nextBundle((ClientJob)it.next(), nbTasks) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTaskBundle nextBundle(final ClientJob bundleWrapper, int nbTasks) {
        ClientTaskBundle result;
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("requesting bundle with " + nbTasks + " tasks, next bundle has " + bundleWrapper.getTaskCount() + " tasks");
            }
            int size = this.getSize(bundleWrapper);
            this.sizeMap.removeValue((Object)size, (Object)bundleWrapper);
            if (nbTasks >= bundleWrapper.getTaskCount()) {
                bundleWrapper.setOnRequeue(new Runnable(){

                    @Override
                    public void run() {
                        JPPFPriorityQueue.this.requeue(bundleWrapper);
                    }
                });
                result = bundleWrapper.copy(bundleWrapper.getTaskCount());
                this.removeBundle(bundleWrapper);
            } else {
                if (debugEnabled) {
                    log.debug("removing " + nbTasks + " tasks from bundle");
                }
                result = bundleWrapper.copy(nbTasks);
                int newSize = bundleWrapper.getTaskCount();
                this.sizeMap.putValue((Object)size, (Object)bundleWrapper);
                this.priorityMap.moveToEndOfList((Object)bundleWrapper.getSLA().getPriority(), (Object)bundleWrapper);
            }
            this.updateLatestMaxSize();
            if (debugEnabled) {
                log.debug("Maps size information: " + CollectionUtils.formatSizeMapInfo((String)"priorityMap", (AbstractCollectionMap)this.priorityMap) + " - " + CollectionUtils.formatSizeMapInfo((String)"sizeMap", (AbstractCollectionMap)this.sizeMap));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.priorityMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int getSize(ClientJob bundleWrapper) {
        return bundleWrapper.getJob().getTasks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientJob removeBundle(ClientJob bundleWrapper) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("removing bundle from queue, jobId=" + bundleWrapper.getName());
            }
            this.priorityMap.removeValue((Object)bundleWrapper.getSLA().getPriority(), (Object)bundleWrapper);
            ClientJob clientJob = null;
            return clientJob;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleStartJobSchedule(ClientJob bundleWrapper) {
        JPPFSchedule schedule = bundleWrapper.getClientSLA().getJobSchedule();
        if (schedule != null) {
            bundleWrapper.setPending(true);
            String jobId = bundleWrapper.getName();
            final String uuid = bundleWrapper.getUuid();
            if (debugEnabled) {
                log.debug("found start " + schedule + " for jobId = " + jobId);
            }
            try {
                long dt = bundleWrapper.getJobReceivedTime();
                this.jobScheduleHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobScheduleAction(bundleWrapper), dt);
                bundleWrapper.addOnDone(new Runnable(){

                    @Override
                    public void run() {
                        JPPFPriorityQueue.this.jobScheduleHandler.cancelAction((Object)uuid);
                    }
                });
            }
            catch (ParseException e) {
                bundleWrapper.setPending(false);
                log.error("Unparseable start date for job id " + jobId + " : date = " + schedule.getDate() + ", date format = " + (schedule.getFormat() == null ? "null" : schedule.getFormat()), (Throwable)e);
            }
        } else {
            bundleWrapper.setPending(false);
        }
    }

    private void handleExpirationJobSchedule(ClientJob bundleWrapper) {
        JPPFSchedule schedule = bundleWrapper.getClientSLA().getJobExpirationSchedule();
        if (schedule != null) {
            String jobId = bundleWrapper.getName();
            final String uuid = bundleWrapper.getUuid();
            if (debugEnabled) {
                log.debug("found expiration " + schedule + " for jobId = " + jobId);
            }
            long dt = bundleWrapper.getJobReceivedTime();
            try {
                this.jobExpirationHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobExpirationAction(bundleWrapper), dt);
                bundleWrapper.addOnDone(new Runnable(){

                    @Override
                    public void run() {
                        JPPFPriorityQueue.this.jobExpirationHandler.cancelAction((Object)uuid);
                    }
                });
            }
            catch (ParseException e) {
                log.error("Unparsable expiration date for job id " + jobId + " : date = " + schedule.getDate() + ", date format = " + (schedule.getFormat() == null ? "null" : schedule.getFormat()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBroadcastJob(final ClientJob bundleWrapper) {
        JPPFJob bundle = bundleWrapper.getJob();
        List<ChannelWrapper> connections = this.submissionManager.getAllConnections();
        if (connections.isEmpty()) {
            this.pendingBroadcasts.offer(bundleWrapper);
            return;
        }
        JobSLA sla = bundle.getSLA();
        ArrayList<ClientJob> jobList = new ArrayList<ClientJob>(connections.size());
        HashSet<String> uuidSet = new HashSet<String>();
        for (ChannelWrapper connection : connections) {
            String uuid;
            ExecutorStatus status = connection.getExecutionStatus();
            if (status != ExecutorStatus.ACTIVE && status != ExecutorStatus.EXECUTING || (uuid = connection.getUuid()) == null || uuid.length() <= 0 || !uuidSet.add(uuid)) continue;
            ClientJob newBundle = bundleWrapper.createBroadcastJob(uuid);
            JPPFManagementInfo info = connection.getManagementInfo();
            newBundle.setSLA((JobSLA)((JPPFJobSLA)sla).copy());
            newBundle.setMetadata(bundle.getMetadata());
            newBundle.setName(bundle.getName() + " [driver: " + info.toString() + ']');
            newBundle.setUuid(new JPPFUuid(JPPFUuid.HEXADECIMAL_CHAR, 32).toString());
            jobList.add(newBundle);
        }
        if (jobList.isEmpty()) {
            bundleWrapper.taskCompleted(null, null);
        } else {
            final String jobUuid = bundleWrapper.getUuid();
            this.lock.lock();
            try {
                ClientJob other = (ClientJob)this.jobMap.get(jobUuid);
                if (other != null) {
                    throw new IllegalStateException("Job " + jobUuid + " already enqueued");
                }
                bundleWrapper.addOnDone(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JPPFPriorityQueue.this.lock.lock();
                        try {
                            JPPFPriorityQueue.this.jobMap.remove(jobUuid);
                            JPPFPriorityQueue.this.removeBundle(bundleWrapper);
                        }
                        finally {
                            JPPFPriorityQueue.this.lock.unlock();
                        }
                    }
                });
                bundleWrapper.setSubmissionStatus(SubmissionStatus.PENDING);
                bundleWrapper.setQueueEntryTime(System.currentTimeMillis());
                bundleWrapper.setJobReceivedTime(bundleWrapper.getQueueEntryTime());
                this.jobMap.put(jobUuid, bundleWrapper);
                this.fireQueueEvent(new QueueEvent((JPPFQueue)this, (Object)bundleWrapper, false));
                for (ClientJob job : jobList) {
                    this.addBundle(job);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePriority(String jobUuid, int newPriority) {
        this.lock.lock();
        try {
            ClientJob job = (ClientJob)this.jobMap.get(jobUuid);
            if (job == null) {
                return;
            }
            int oldPriority = job.getJob().getSLA().getPriority();
            if (oldPriority != newPriority) {
                job.getJob().getSLA().setPriority(newPriority);
                this.priorityMap.removeValue((Object)oldPriority, (Object)job);
                this.priorityMap.putValue((Object)newPriority, (Object)job);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelJob(String jobId) {
        this.lock.lock();
        try {
            ClientJob job = (ClientJob)this.jobMap.get(jobId);
            if (job == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = job.cancel(false);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            this.jobScheduleHandler.clear(true);
            this.jobExpirationHandler.clear(true);
            this.pendingBroadcasts.clear();
            this.jobMap.clear();
            this.priorityMap.clear();
            this.sizeMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBroadcastJobs(String connectionUUID) {
        if (connectionUUID == null || connectionUUID.isEmpty()) {
            return;
        }
        Set<String> jobIDs = Collections.emptySet();
        this.lock.lock();
        try {
            if (this.jobMap.isEmpty()) {
                return;
            }
            jobIDs = new HashSet<String>();
            for (Map.Entry entry : this.jobMap.entrySet()) {
                if (!connectionUUID.equals(((ClientJob)entry.getValue()).getBroadcastUUID())) continue;
                jobIDs.add((String)entry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
        for (String jobID : jobIDs) {
            this.cancelJob(jobID);
        }
    }

    public void processPendingBroadcasts() {
        ClientJob clientJob;
        if (!this.submissionManager.hasWorkingConnection()) {
            return;
        }
        while ((clientJob = this.pendingBroadcasts.poll()) != null) {
            if (debugEnabled) {
                log.debug("queuing job " + clientJob.getJob());
            }
            this.addBundle(clientJob);
        }
    }
}

