/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.JPPFResultCollector;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ChannelWrapperLocal;
import org.jppf.client.balancer.ChannelWrapperRemote;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.client.balancer.queue.TaskQueueChecker;
import org.jppf.client.balancer.stats.JPPFClientStatsManager;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ClientEvent;
import org.jppf.client.event.ClientListener;
import org.jppf.client.event.SubmissionStatusListener;
import org.jppf.client.submission.SubmissionManager;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.queue.QueueEvent;
import org.jppf.queue.QueueListener;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.spi.JPPFBundlerFactory;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionManagerClient
extends ThreadSynchronization
implements SubmissionManager {
    private static final Logger log = LoggerFactory.getLogger(SubmissionManagerClient.class);
    private final JPPFPriorityQueue queue;
    private final JPPFClientStatsManager statsManager = new JPPFClientStatsManager();
    private final JPPFBundlerFactory bundlerFactory = new JPPFBundlerFactory(JPPFBundlerFactory.CLIENT_DEFAULTS);
    private final TaskQueueChecker<ChannelWrapper<?>> taskQueueChecker;
    private final Map<AbstractJPPFClientConnection, ChannelWrapper<?>> wrapperMap = new HashMap();
    private final List<ChannelWrapper<?>> allConnections = new ArrayList();
    private final ClientConnectionStatusListener statusListener = new ClientConnectionStatusListener(){

        @Override
        public void statusChanged(ClientConnectionStatusEvent event) {
            if (event.getSource() instanceof JPPFClientConnection) {
                SubmissionManagerClient.this.updateConnectionStatus((JPPFClientConnection)event.getSource(), event.getOldStatus());
            } else if (event.getSource() instanceof ChannelWrapper) {
                SubmissionManagerClient.this.updateConnectionStatus((ChannelWrapper)event.getSource(), event.getOldStatus());
            }
        }
    };
    private boolean localEnabled;
    private ChannelWrapperLocal wrapperLocal = null;
    private final AtomicInteger nbWorkingConnections = new AtomicInteger(0);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SubmissionManagerClient(AbstractGenericClient client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.localEnabled = client.getConfig().getBoolean("jppf.local.execution.enabled", false);
        Bundler bundler = this.bundlerFactory.createBundlerFromJPPFConfiguration();
        this.queue = new JPPFPriorityQueue(this);
        this.taskQueueChecker = new TaskQueueChecker(this.queue, this.statsManager);
        this.taskQueueChecker.setBundler(bundler);
        this.queue.addQueueListener((QueueListener)new QueueListener<ClientJob, ClientJob, ClientTaskBundle>(){

            public void newBundle(QueueEvent<ClientJob, ClientJob, ClientTaskBundle> event) {
                SubmissionManagerClient.this.taskQueueChecker.wakeUp();
            }
        });
        new Thread(this.taskQueueChecker, "TaskQueueChecker").start();
        client.addClientListener(new ClientListener(){

            @Override
            public void newConnection(ClientEvent event) {
                SubmissionManagerClient.this.addConnection(event.getConnection());
            }

            @Override
            public void connectionFailed(ClientEvent event) {
                SubmissionManagerClient.this.removeConnection(event.getConnection());
            }
        });
        this.updateLocalExecution(this.localEnabled);
        List<JPPFClientConnection> connections = client.getAllConnections();
        for (JPPFClientConnection connection : connections) {
            this.addConnection(connection);
        }
    }

    protected synchronized void addConnection(ChannelWrapper<?> wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("this submission manager was closed");
        }
        this.allConnections.add(wrapper);
        this.updateConnectionStatus(wrapper, JPPFClientConnectionStatus.NEW, wrapper.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeConnection(ChannelWrapper<?> wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper is null");
        }
        try {
            this.updateConnectionStatus(wrapper, wrapper.getStatus(), JPPFClientConnectionStatus.DISCONNECTED);
        }
        finally {
            this.allConnections.remove(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ChannelWrapper<?> addConnection(JPPFClientConnection cnn) {
        if (log.isDebugEnabled()) {
            log.debug("adding connection " + cnn);
        }
        if (this.closed.get()) {
            throw new IllegalStateException("this submission manager was closed");
        }
        AbstractJPPFClientConnection connection = (AbstractJPPFClientConnection)cnn;
        ChannelWrapperRemote wrapper = this.wrapperMap.get(connection);
        if (wrapper == null) {
            try {
                wrapper = new ChannelWrapperRemote(connection);
                JMXDriverConnectionWrapper jmxConnection = connection.getJmxConnection();
                JPPFSystemInformation systemInfo = connection.getSystemInfo();
                if (systemInfo != null) {
                    ((ChannelWrapper)wrapper).setSystemInformation(systemInfo);
                }
                JPPFManagementInfo info = new JPPFManagementInfo(jmxConnection.getHost(), jmxConnection.getPort(), ((AbstractJPPFClientConnection)cnn).getUuid(), 0, cnn.isSSL());
                if (systemInfo != null) {
                    info.setSystemInfo(systemInfo);
                }
                wrapper.setManagementInfo(info);
            }
            catch (Throwable e) {
                log.error("Error while adding connection " + cnn, e);
            }
            finally {
                this.wrapperMap.put(connection, wrapper);
                this.addConnection(wrapper);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("end of adding connection " + cnn);
        }
        return wrapper;
    }

    protected synchronized ChannelWrapper removeConnection(JPPFClientConnection cnn) {
        AbstractJPPFClientConnection connection = (AbstractJPPFClientConnection)cnn;
        ChannelWrapper<?> wrapper = this.wrapperMap.remove(connection);
        if (wrapper != null) {
            this.removeConnection(wrapper);
        }
        return wrapper;
    }

    public synchronized List<ChannelWrapper> getAllConnections() {
        return new ArrayList<ChannelWrapper>(this.allConnections);
    }

    public synchronized boolean hasWorkingConnection() {
        return this.nbWorkingConnections.get() > 0;
    }

    private void updateConnectionStatus(JPPFClientConnection cnn, JPPFClientConnectionStatus oldStatus) {
        AbstractJPPFClientConnection connection = (AbstractJPPFClientConnection)cnn;
        ChannelWrapper<?> wrapper = this.wrapperMap.get(connection);
        if (wrapper != null) {
            if (oldStatus == JPPFClientConnectionStatus.CONNECTING && wrapper.getStatus() == JPPFClientConnectionStatus.ACTIVE) {
                JPPFSystemInformation systemInfo = connection.getSystemInfo();
                JMXDriverConnectionWrapper jmxConnection = connection.getJmxConnection();
                wrapper.setSystemInformation(systemInfo);
                JPPFManagementInfo info = new JPPFManagementInfo(jmxConnection.getHost(), jmxConnection.getPort(), jmxConnection.getId(), 0);
                info.setSystemInfo(systemInfo);
                wrapper.setManagementInfo(info);
            }
            this.updateConnectionStatus(wrapper, oldStatus);
        }
    }

    private void updateConnectionStatus(ChannelWrapper<?> wrapper, JPPFClientConnectionStatus oldStatus) {
        if (wrapper == null) {
            return;
        }
        this.updateConnectionStatus(wrapper, oldStatus, wrapper.getStatus());
    }

    private void updateConnectionStatus(ChannelWrapper<?> wrapper, JPPFClientConnectionStatus oldStatus, JPPFClientConnectionStatus newStatus) {
        boolean bOld;
        if (oldStatus == null) {
            throw new IllegalArgumentException("oldStatus is null");
        }
        if (newStatus == null) {
            throw new IllegalArgumentException("newStatus is null");
        }
        if (wrapper == null || oldStatus == newStatus) {
            return;
        }
        if (newStatus == JPPFClientConnectionStatus.ACTIVE) {
            this.taskQueueChecker.addIdleChannel(wrapper);
        } else {
            this.taskQueueChecker.removeIdleChannel(wrapper);
            if (newStatus == JPPFClientConnectionStatus.FAILED || newStatus == JPPFClientConnectionStatus.DISCONNECTED) {
                this.queue.cancelBroadcastJobs(wrapper.getUuid());
            }
        }
        boolean bNew = newStatus == JPPFClientConnectionStatus.ACTIVE || newStatus == JPPFClientConnectionStatus.EXECUTING;
        boolean bl = bOld = oldStatus == JPPFClientConnectionStatus.ACTIVE || oldStatus == JPPFClientConnectionStatus.EXECUTING;
        if (bNew && !bOld) {
            this.nbWorkingConnections.incrementAndGet();
        } else if (!bNew && bOld) {
            this.nbWorkingConnections.decrementAndGet();
        }
    }

    @Override
    public String submitJob(JPPFJob job) {
        return this.submitJob(job, null);
    }

    @Override
    public String submitJob(JPPFJob job, SubmissionStatusListener listener) {
        if (this.closed.get()) {
            throw new IllegalStateException("this submission manager was closed");
        }
        ArrayList<JPPFTask> pendingTasks = new ArrayList<JPPFTask>();
        if (listener != null && job.getResultListener() instanceof JPPFResultCollector) {
            ((JPPFResultCollector)job.getResultListener()).addSubmissionStatusListener(listener);
        }
        List<JPPFTask> tasks = job.getTasks();
        for (JPPFTask task : tasks) {
            if (job.getResults().hasResult(task.getPosition())) continue;
            pendingTasks.add(task);
        }
        this.queue.addBundle(new ClientJob(job, pendingTasks));
        return job.getUuid();
    }

    @Override
    public String resubmitJob(JPPFJob job) {
        return this.submitJob(job);
    }

    public boolean cancelJob(String jobId) throws Exception {
        this.queue.cancelJob(jobId);
        return true;
    }

    @Override
    public synchronized boolean hasAvailableConnection() {
        return this.taskQueueChecker.hasIdleChannel() || this.wrapperLocal != null && this.wrapperLocal.getStatus() == JPPFClientConnectionStatus.ACTIVE;
    }

    @Override
    public synchronized boolean isLocalExecutionEnabled() {
        return this.localEnabled;
    }

    @Override
    public synchronized void setLocalExecutionEnabled(boolean localExecutionEnabled) {
        if (this.localEnabled == localExecutionEnabled) {
            return;
        }
        this.localEnabled = localExecutionEnabled;
        this.updateLocalExecution(this.localEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateLocalExecution(boolean localExecutionEnabled) {
        if (this.closed.get()) {
            throw new IllegalStateException("this submission manager was closed");
        }
        if (localExecutionEnabled) {
            this.wrapperLocal = new ChannelWrapperLocal();
            this.wrapperLocal.addClientConnectionStatusListener(this.statusListener);
            this.addConnection(this.wrapperLocal);
        } else if (this.wrapperLocal != null) {
            try {
                this.wrapperLocal.close();
            }
            finally {
                this.removeConnection(this.wrapperLocal);
                this.wrapperLocal = null;
            }
        }
    }

    @Override
    public Vector<JPPFClientConnection> getAvailableConnections() {
        List<ChannelWrapper<?>> idleChannels = this.taskQueueChecker.getIdleChannels();
        Vector<JPPFClientConnection> availableConnections = new Vector<JPPFClientConnection>(idleChannels.size());
        for (ChannelWrapper<?> idleChannel : idleChannels) {
            if (!(idleChannel instanceof ChannelWrapperRemote)) continue;
            ChannelWrapperRemote wrapperRemote = (ChannelWrapperRemote)idleChannel;
            availableConnections.add(wrapperRemote.getChannel());
        }
        return availableConnections;
    }

    @Override
    public ClientConnectionStatusListener getClientConnectionStatusListener() {
        return this.statusListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed.set(true);
        this.setStopped(true);
        this.wakeUp();
        if (this.taskQueueChecker != null) {
            this.taskQueueChecker.setStopped(true);
            this.taskQueueChecker.wakeUp();
        }
        this.queue.close();
        SubmissionManagerClient submissionManagerClient = this;
        synchronized (submissionManagerClient) {
            for (ChannelWrapper<?> channel : this.allConnections) {
                channel.close();
            }
            this.allConnections.clear();
        }
    }
}

