/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ClientJob;
import org.jppf.execute.ExecutorChannel;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.task.storage.DataProvider;

public class ClientTaskBundle
extends JPPFTaskBundle {
    private static final long serialVersionUID = 1L;
    private final ClientJob job;
    private transient DataProvider dataProvider = null;
    private transient List<JPPFTask> tasks = null;
    private transient String broadcastUUID = null;
    private boolean requeued = false;
    private boolean cancelled = false;

    public ClientTaskBundle(ClientJob job, List<JPPFTask> tasks) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        this.job = job;
        this.setSLA(job.getSLA());
        this.setMetadata(job.getJob().getMetadata());
        this.tasks = new ArrayList<JPPFTask>(tasks);
        this.setName(job.getJob().getName());
        this.setTaskCount(this.tasks.size());
    }

    public JPPFJob getJob() {
        return this.job.getJob();
    }

    public ClientJob getClientJob() {
        return this.job;
    }

    public DataProvider getDataProviderL() {
        return this.dataProvider;
    }

    public void setDataProviderL(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public List<JPPFTask> getTasksL() {
        return this.tasks;
    }

    public ClientTaskBundle copy() {
        throw new UnsupportedOperationException();
    }

    public ClientTaskBundle copy(int nbTasks) {
        throw new UnsupportedOperationException();
    }

    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    public void setBroadcastUUID(String broadcastUUID) {
        this.broadcastUUID = broadcastUUID;
    }

    public void jobDispatched(ExecutorChannel channel, Future<?> future) {
        this.job.jobDispatched(this, channel, future);
    }

    public void resultsReceived(List<JPPFTask> results) {
        this.job.resultsReceived(this, results);
    }

    public void resultsReceived(Throwable throwable) {
        this.job.resultsReceived(this, throwable);
    }

    public void taskCompleted(Exception exception) {
        this.job.taskCompleted(this, exception);
    }

    public synchronized void resubmit() {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.requeued = true;
    }

    public synchronized boolean isRequeued() {
        return this.requeued;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("jobId=").append(this.getName());
        sb.append(", jobUuid=").append(this.getUuid());
        sb.append(", initialTaskCount=").append(this.getInitialTaskCount());
        sb.append(", taskCount=").append(this.getTaskCount());
        sb.append(", requeue=").append(this.isRequeued());
        sb.append(", cancelled=").append(this.isCancelled());
        sb.append(']');
        return sb.toString();
    }
}

