/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.jppf.JPPFException;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.utils.AbstractClientJob;
import org.jppf.client.event.JobEvent;
import org.jppf.client.event.TaskResultEvent;
import org.jppf.client.event.TaskResultListener;
import org.jppf.client.submission.SubmissionStatus;
import org.jppf.client.submission.SubmissionStatusHandler;
import org.jppf.execute.ExecutorChannel;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientJob
extends AbstractClientJob {
    private static final Logger log = LoggerFactory.getLogger(ClientJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final List<JPPFTask> tasks;
    private transient String broadcastUUID = null;
    private final Map<ClientTaskBundle, Future> bundleMap = new LinkedHashMap<ClientTaskBundle, Future>();
    private SubmissionStatus submissionStatus;
    private TaskResultListener resultsListener;
    private transient ClientJob parentJob;
    private final Map<String, ClientJob> broadcastMap;
    private final Set<ClientJob> broadcastSet = new LinkedHashSet<ClientJob>();
    private boolean executing = false;
    private Runnable onRequeue = null;
    private final SortedMap<Integer, TaskState> taskStateMap = new TreeMap<Integer, TaskState>();

    public ClientJob(JPPFJob job, List<JPPFTask> tasks) {
        this(job, tasks, null, null);
    }

    protected ClientJob(JPPFJob job, List<JPPFTask> tasks, ClientJob parentJob, String broadcastUUID) {
        super(job);
        if (tasks == null) {
            throw new IllegalArgumentException("tasks is null");
        }
        this.parentJob = parentJob;
        this.broadcastUUID = broadcastUUID;
        if (broadcastUUID == null) {
            this.broadcastMap = job.getSLA().isBroadcastJob() ? new LinkedHashMap<String, ClientJob>() : Collections.emptyMap();
            this.resultsListener = this.job.getResultListener();
        } else {
            this.broadcastMap = Collections.emptyMap();
            this.resultsListener = null;
        }
        this.submissionStatus = this.job.getResultListener() instanceof SubmissionStatusHandler ? ((SubmissionStatusHandler)((Object)this.job.getResultListener())).getStatus() : SubmissionStatus.SUBMITTED;
        this.tasks = new ArrayList<JPPFTask>(tasks);
        for (JPPFTask result : job.getResults().getAll()) {
            if (result == null) continue;
            this.taskStateMap.put(result.getPosition(), TaskState.RESULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExecuting(boolean executing) {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            if (this.executing == executing) {
                return;
            }
            this.executing = executing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskCount() {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            return this.tasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFTask> getTasks() {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JPPFTask>(this.tasks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientJob createBroadcastJob(String broadcastUUID) {
        ClientJob clientJob;
        if (broadcastUUID == null || broadcastUUID.isEmpty()) {
            throw new IllegalArgumentException("broadcastUUID is blank");
        }
        Object object = this.tasks;
        synchronized (object) {
            clientJob = new ClientJob(this.job, this.tasks, this, broadcastUUID);
        }
        object = this.bundleMap;
        synchronized (object) {
            this.broadcastSet.add(clientJob);
        }
        return clientJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientTaskBundle copy(int nbTasks) {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            if (nbTasks >= this.tasks.size()) {
                try {
                    ClientTaskBundle clientTaskBundle = new ClientTaskBundle(this, this.tasks);
                    return clientTaskBundle;
                }
                finally {
                    this.tasks.clear();
                }
            }
            List<JPPFTask> subList = this.tasks.subList(0, nbTasks);
            try {
                ClientTaskBundle clientTaskBundle = new ClientTaskBundle(this, subList);
                return clientTaskBundle;
            }
            finally {
                subList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean merge(List<JPPFTask> taskList, boolean after) {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            boolean requeue;
            boolean bl = requeue = this.tasks.isEmpty() && !taskList.isEmpty();
            if (!after) {
                this.tasks.addAll(0, taskList);
            }
            if (after) {
                this.tasks.addAll(taskList);
            }
            return requeue;
        }
    }

    public TaskResultListener getResultListener() {
        return this.resultsListener;
    }

    public void setResultListener(TaskResultListener resultsListener) {
        this.resultsListener = resultsListener;
    }

    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDispatched(ClientTaskBundle bundle, ExecutorChannel channel, Future<?> future) {
        boolean empty;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (future == null) {
            throw new IllegalArgumentException("future is null");
        }
        Map<ClientTaskBundle, Future> map = this.bundleMap;
        synchronized (map) {
            empty = this.bundleMap.isEmpty();
            this.bundleMap.put(bundle, future);
        }
        if (empty) {
            this.updateStatus(0, 1);
            this.setSubmissionStatus(SubmissionStatus.EXECUTING);
            this.setExecuting(true);
        }
        this.job.fireJobEvent(JobEvent.Type.JOB_DISPATCH, channel, bundle.getTasksL());
        if (this.parentJob != null) {
            this.parentJob.broadcastDispatched(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ClientTaskBundle bundle, List<JPPFTask> results) {
        if (debugEnabled) {
            log.debug("received " + results.size() + " results for bundle " + (Object)((Object)bundle));
        }
        if (results.isEmpty()) {
            return;
        }
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            for (JPPFTask task : results) {
                this.taskStateMap.put(task.getPosition(), TaskState.RESULT);
            }
        }
        TaskResultListener listener = this.resultsListener;
        if (listener != null) {
            TaskResultListener taskResultListener = listener;
            synchronized (taskResultListener) {
                listener.resultsReceived(new TaskResultEvent(results, null));
            }
        }
        this.job.fireJobEvent(JobEvent.Type.JOB_RETURN, null, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ClientTaskBundle bundle, Throwable throwable) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (debugEnabled) {
            log.debug("received  throwable " + throwable + " for bundle " + (Object)((Object)bundle));
        }
        boolean ioe = this.isIOException(throwable);
        Exception e = throwable instanceof Exception ? (Exception)throwable : new JPPFException(throwable);
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            for (JPPFTask task : bundle.getTasksL()) {
                TaskState oldState = (TaskState)this.taskStateMap.get(task.getPosition());
                if (ioe || oldState == TaskState.RESULT) continue;
                this.taskStateMap.put(task.getPosition(), TaskState.EXCEPTION);
                task.setException(e);
            }
        }
        TaskResultListener listener = this.resultsListener;
        if (listener != null) {
            TaskResultListener taskResultListener = listener;
            synchronized (taskResultListener) {
                listener.resultsReceived(new TaskResultEvent(bundle.getTasksL(), throwable));
            }
        }
        this.job.fireJobEvent(JobEvent.Type.JOB_RETURN, null, bundle.getTasksL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(ClientTaskBundle bundle, Exception exception) {
        ArrayList<JPPFTask> list;
        boolean empty;
        if (debugEnabled) {
            log.debug("bundle=" + (Object)((Object)bundle) + ", exception=" + exception + " for " + this);
        }
        Map<ClientTaskBundle, Future> map = this.bundleMap;
        synchronized (map) {
            Future future = this.bundleMap.remove((Object)bundle);
            if (bundle != null && future == null) {
                throw new IllegalStateException("future already removed");
            }
            empty = this.bundleMap.isEmpty() && this.broadcastMap.isEmpty();
        }
        boolean requeue = false;
        if (this.getSLA().isBroadcastJob()) {
            list = new ArrayList<JPPFTask>();
            List<JPPFTask> list2 = this.tasks;
            synchronized (list2) {
                if (bundle != null) {
                    for (JPPFTask task : bundle.getTasksL()) {
                        if (this.taskStateMap.put(task.getPosition(), TaskState.RESULT) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                }
                if (this.isCancelled() || this.getBroadcastUUID() == null) {
                    list.addAll(this.tasks);
                    this.tasks.clear();
                }
            }
            this.resultsReceived(bundle, list);
        } else if (bundle == null) {
            if (this.isCancelled()) {
                list = new ArrayList();
                List<JPPFTask> list3 = this.tasks;
                synchronized (list3) {
                    list.addAll(this.tasks);
                    this.tasks.clear();
                }
                this.resultsReceived(bundle, list);
            }
        } else {
            List<JPPFTask> list4;
            if (bundle.isCancelled()) {
                list = new ArrayList();
                list4 = this.tasks;
                synchronized (list4) {
                    for (JPPFTask task : bundle.getTasksL()) {
                        if (this.taskStateMap.get(task.getPosition()) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                    list.addAll(this.tasks);
                    this.tasks.clear();
                }
                this.resultsReceived(bundle, list);
            }
            if (bundle.isRequeued()) {
                list = new ArrayList();
                list4 = this.tasks;
                synchronized (list4) {
                    for (JPPFTask task : bundle.getTasksL()) {
                        if (this.taskStateMap.get(task.getPosition()) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                    requeue = this.merge(list, false);
                }
            }
        }
        if (this.hasPending()) {
            if (exception != null) {
                this.setSubmissionStatus(exception instanceof NotSerializableException ? SubmissionStatus.COMPLETE : SubmissionStatus.FAILED);
            }
            if (empty) {
                this.setExecuting(false);
            }
            if (requeue && this.onRequeue != null) {
                this.onRequeue.run();
            }
        } else {
            boolean callDone = this.updateStatus(1, 2);
            if (empty) {
                this.setExecuting(false);
            }
            try {
                if (callDone) {
                    this.done();
                }
            }
            finally {
                if (this.parentJob != null) {
                    this.parentJob.broadcastCompleted(this);
                }
            }
            this.setSubmissionStatus(SubmissionStatus.COMPLETE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPending() {
        List<JPPFTask> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty() && this.taskStateMap.size() >= this.job.getTasks().size()) {
                for (TaskState state : this.taskStateMap.values()) {
                    if (state != TaskState.EXCEPTION) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public SubmissionStatus getSubmissionStatus() {
        return this.submissionStatus;
    }

    public void setSubmissionStatus(SubmissionStatus submissionStatus) {
        if (this.submissionStatus == submissionStatus) {
            return;
        }
        this.submissionStatus = submissionStatus;
        if (this.resultsListener instanceof SubmissionStatusHandler) {
            ((SubmissionStatusHandler)((Object)this.resultsListener)).setStatus(this.submissionStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            boolean empty;
            ArrayList<Future> futureList;
            ArrayList<ClientJob> list;
            this.done();
            Map<ClientTaskBundle, Future> map = this.bundleMap;
            synchronized (map) {
                list = new ArrayList<ClientJob>(this.broadcastSet.size() + this.broadcastMap.size());
                list.addAll(this.broadcastMap.values());
                list.addAll(this.broadcastSet);
                futureList = new ArrayList<Future>(this.bundleMap.size());
                futureList.addAll(this.bundleMap.values());
            }
            for (ClientJob broadcastJob : list) {
                broadcastJob.cancel(mayInterruptIfRunning);
            }
            for (Future future : futureList) {
                try {
                    if (future.isDone()) continue;
                    future.cancel(false);
                }
                catch (Exception e) {
                    log.error("Error cancelling job " + this, (Throwable)e);
                }
            }
            Map<ClientTaskBundle, Future> map2 = this.bundleMap;
            synchronized (map2) {
                this.broadcastSet.clear();
                empty = this.bundleMap.isEmpty() && this.broadcastMap.isEmpty();
            }
            if (empty) {
                this.taskCompleted(null, null);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastDispatched(ClientJob broadcastJob) {
        boolean empty;
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        Map<ClientTaskBundle, Future> map = this.bundleMap;
        synchronized (map) {
            this.broadcastSet.remove(broadcastJob);
            empty = this.broadcastMap.isEmpty();
            this.broadcastMap.put(broadcastJob.getBroadcastUUID(), broadcastJob);
        }
        if (empty) {
            this.updateStatus(0, 1);
            this.setSubmissionStatus(SubmissionStatus.EXECUTING);
            this.setExecuting(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastCompleted(ClientJob broadcastJob) {
        boolean empty;
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        Map<ClientTaskBundle, Future> map = this.bundleMap;
        synchronized (map) {
            if (this.broadcastMap.remove(broadcastJob.getBroadcastUUID()) != broadcastJob && !this.broadcastSet.contains(broadcastJob)) {
                throw new IllegalStateException("broadcast job not found");
            }
            empty = this.broadcastMap.isEmpty();
        }
        if (empty) {
            this.taskCompleted(null, null);
        }
    }

    public void setOnRequeue(Runnable onRequeue) {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.onRequeue = onRequeue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbChannels() {
        Map<ClientTaskBundle, Future> map = this.bundleMap;
        synchronized (map) {
            return this.bundleMap.size();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("job=").append(this.job);
        sb.append(", submissionStatus=").append((Object)this.submissionStatus);
        sb.append(", broadcastUUID=").append(this.broadcastUUID);
        sb.append(", executing=").append(this.executing);
        sb.append(", nbTasks=").append(this.tasks.size());
        sb.append(", taskStateMap=").append(this.taskStateMap);
        sb.append(']');
        return sb.toString();
    }

    private boolean isIOException(Throwable t) {
        return t instanceof IOException && !(t instanceof NotSerializableException);
    }
}

