/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.io.NotSerializableException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jppf.JPPFException;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusHandler;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.execute.JPPFFuture;
import org.jppf.execute.JPPFFutureTask;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWrapperRemote
extends ChannelWrapper<ClientTaskBundle>
implements ClientConnectionStatusHandler {
    private static Logger log = LoggerFactory.getLogger(ChannelWrapperRemote.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final AbstractJPPFClientConnection channel;
    protected String uuid = null;

    public ChannelWrapperRemote(AbstractJPPFClientConnection channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.channel = channel;
        this.uuid = channel.getUuid();
        this.systemInfo = new JPPFSystemInformation(this.uuid, false, true);
        this.managementInfo = new JPPFManagementInfo("remote", -1, this.getConnectionUuid(), 0);
        this.managementInfo.setSystemInfo(this.systemInfo);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("RemoteChannelWrapper" + channel.getName() + '-'));
    }

    @Override
    public void setSystemInformation(JPPFSystemInformation systemInfo) {
        if (systemInfo != null && this.uuid == null) {
            this.uuid = systemInfo.getUuid().getProperty("jppf.uuid");
            if (this.uuid != null && this.uuid.isEmpty()) {
                this.uuid = null;
            }
        }
        super.setSystemInformation(systemInfo);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getConnectionUuid() {
        return this.channel.getConnectionUuid();
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.channel.getStatus();
    }

    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        this.channel.getTaskServerConnection().setStatus(status);
    }

    public AbstractJPPFClientConnection getChannel() {
        return this.channel;
    }

    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.channel.addClientConnectionStatusListener(listener);
    }

    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.channel.removeClientConnectionStatusListener(listener);
    }

    public JPPFFuture<?> submit(final ClientTaskBundle bundle) {
        this.setStatus(JPPFClientConnectionStatus.EXECUTING);
        JPPFFutureTask task = new JPPFFutureTask(new RemoteRunnable(this.getBundler(), bundle, this.channel), null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isDone()) {
                    return false;
                }
                if (this.isCancelled()) {
                    return true;
                }
                bundle.cancel();
                try {
                    ChannelWrapperRemote.this.channel.cancelJob(bundle.getClientJob().getUuid());
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    log.warn(ExceptionUtils.getMessage((Throwable)e));
                }
                finally {
                    return super.cancel(false);
                }
            }
        };
        bundle.jobDispatched(this, (Future<?>)task);
        this.executor.execute((Runnable)task);
        return task;
    }

    public boolean isLocal() {
        return false;
    }

    public void reconnect() {
        this.setStatus(JPPFClientConnectionStatus.DISCONNECTED);
        try {
            this.channel.getTaskServerConnection().init();
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[channel=").append(this.channel);
        sb.append(']');
        return sb.toString();
    }

    private class RemoteRunnable
    implements Runnable {
        private final ClientTaskBundle bundle;
        private final Bundler bundler;
        private final AbstractJPPFClientConnection connection;

        public RemoteRunnable(Bundler bundler, ClientTaskBundle bundle, AbstractJPPFClientConnection connection) {
            this.bundler = bundler;
            this.bundle = bundle;
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception exception = null;
            List<JPPFTask> tasks = this.bundle.getTasksL();
            AbstractGenericClient client = this.connection.getClient();
            AbstractGenericClient.RegisteredClassLoader registeredClassLoader = null;
            try {
                long start = System.nanoTime();
                int count = 0;
                boolean completed = false;
                JPPFJob newJob = this.createNewJob(this.bundle, tasks);
                ClassLoader classLoader = this.getClassLoader(newJob);
                registeredClassLoader = client.registerClassLoader(classLoader, newJob.getUuid());
                while (!completed) {
                    JPPFTaskBundle bundle = this.createBundle(newJob);
                    bundle.setRequestUuid(registeredClassLoader.getUuid());
                    this.connection.sendTasks(classLoader, bundle, newJob);
                    while (count < tasks.size()) {
                        List<JPPFTask> results = this.connection.receiveResults(classLoader);
                        int n = results.size();
                        count += n;
                        if (debugEnabled) {
                            log.debug("received " + n + " tasks from server" + (n > 0 ? ", first position=" + results.get(0).getPosition() : ""));
                        }
                        this.bundle.resultsReceived(results);
                    }
                    completed = true;
                }
                double elapsed = System.nanoTime() - start;
                this.bundler.feedback(tasks.size(), elapsed);
                if (registeredClassLoader != null) {
                    registeredClassLoader.dispose();
                }
                this.bundle.taskCompleted(exception);
            }
            catch (Throwable t) {
                block18: {
                    try {
                        if (debugEnabled) {
                            log.debug(t.getMessage(), t);
                        } else {
                            log.warn(ExceptionUtils.getMessage((Throwable)t));
                        }
                        exception = t instanceof Exception ? (Exception)t : new JPPFException(t);
                        this.bundle.resultsReceived(t);
                        if (!(t instanceof NotSerializableException) && !(t instanceof InterruptedException)) break block18;
                        if (registeredClassLoader != null) {
                            registeredClassLoader.dispose();
                        }
                        this.bundle.taskCompleted(exception);
                    }
                    catch (Throwable throwable) {
                        if (registeredClassLoader != null) {
                            registeredClassLoader.dispose();
                        }
                        this.bundle.taskCompleted(exception);
                        this.bundle.getClientJob().removeChannel(ChannelWrapperRemote.this);
                        if (ChannelWrapperRemote.this.getStatus() == JPPFClientConnectionStatus.EXECUTING) {
                            ChannelWrapperRemote.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                        }
                        throw throwable;
                    }
                    this.bundle.getClientJob().removeChannel(ChannelWrapperRemote.this);
                    if (ChannelWrapperRemote.this.getStatus() == JPPFClientConnectionStatus.EXECUTING) {
                        ChannelWrapperRemote.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                    }
                    return;
                }
                this.bundle.resubmit();
                ChannelWrapperRemote.this.reconnect();
                if (registeredClassLoader != null) {
                    registeredClassLoader.dispose();
                }
                this.bundle.taskCompleted(exception);
                this.bundle.getClientJob().removeChannel(ChannelWrapperRemote.this);
                if (ChannelWrapperRemote.this.getStatus() == JPPFClientConnectionStatus.EXECUTING) {
                    ChannelWrapperRemote.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                }
            }
            this.bundle.getClientJob().removeChannel(ChannelWrapperRemote.this);
            if (ChannelWrapperRemote.this.getStatus() == JPPFClientConnectionStatus.EXECUTING) {
                ChannelWrapperRemote.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            }
        }

        private JPPFJob createNewJob(ClientTaskBundle job, List<JPPFTask> tasks) throws Exception {
            JPPFJob newJob = new JPPFJob(job.getClientJob().getUuid());
            newJob.setDataProvider(job.getJob().getDataProvider());
            newJob.setSLA(job.getSLA());
            newJob.setClientSLA(job.getJob().getClientSLA());
            newJob.setMetadata(job.getMetadata());
            newJob.setBlocking(job.getJob().isBlocking());
            newJob.setName(job.getName());
            for (JPPFTask task : tasks) {
                int pos = task.getPosition();
                newJob.addTask(task, new Object[0]);
                task.setPosition(pos);
            }
            return newJob;
        }

        private JPPFTaskBundle createBundle(JPPFJob job) {
            String requestUuid = job.getUuid();
            JPPFTaskBundle bundle = new JPPFTaskBundle();
            bundle.setRequestUuid(requestUuid);
            return bundle;
        }

        private ClassLoader getClassLoader(JPPFJob job) {
            if (job == null) {
                throw new IllegalArgumentException("job is null");
            }
            if (job.getTasks().isEmpty()) {
                return null;
            }
            Object task = job.getTasks().get(0);
            if (task instanceof JPPFAnnotatedTask) {
                task = ((JPPFAnnotatedTask)task).getTaskObject();
            }
            return task.getClass().getClassLoader();
        }
    }
}

