/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jppf.JPPFException;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusHandler;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.execute.ExecutorStatus;
import org.jppf.execute.JPPFFuture;
import org.jppf.execute.JPPFFutureTask;
import org.jppf.management.JMXServer;
import org.jppf.management.JMXServerFactory;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.Node;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.server.node.NodeExecutionManagerImpl;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWrapperLocal
extends ChannelWrapper<ClientTaskBundle>
implements ClientConnectionStatusHandler,
Node {
    private static Logger log = LoggerFactory.getLogger(ChannelWrapperLocal.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final NodeExecutionManagerImpl executionManager;
    private JPPFClientConnectionStatus status = JPPFClientConnectionStatus.ACTIVE;
    private final String connectionUuid = UUID.randomUUID().toString();
    private final List<ClientConnectionStatusListener> listeners = new ArrayList<ClientConnectionStatusListener>();
    private ClientConnectionStatusListener[] listenersArray;
    private static JMXServer jmxServer = null;
    protected final LifeCycleEventHandler lifeCycleEventHandler;

    public ChannelWrapperLocal() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("LocalChannelWrapper"));
        this.executionManager = new NodeExecutionManagerImpl((Node)this, "jppf.local.execution.threads");
        this.lifeCycleEventHandler = new LifeCycleEventHandler((Node)this);
        this.systemInfo = new JPPFSystemInformation(this.getConnectionUuid(), true, false);
        this.managementInfo = new JPPFManagementInfo("local", -1, this.getConnectionUuid(), 65);
        this.managementInfo.setSystemInfo(this.systemInfo);
    }

    public String getUuid() {
        return this.connectionUuid;
    }

    public String getConnectionUuid() {
        return this.connectionUuid;
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        ExecutorStatus oldExecutionStatus = this.getExecutionStatus();
        JPPFClientConnectionStatus oldValue = this.status;
        this.status = status;
        this.fireStatusChanged(oldValue, this.status);
        ExecutorStatus newExecutionStatus = this.getExecutionStatus();
        this.fireExecutionStatusChanged(oldExecutionStatus, newExecutionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            this.listenersArray = this.listeners.toArray(new ClientConnectionStatusListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            this.listenersArray = this.listeners.toArray(new ClientConnectionStatusListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChanged(JPPFClientConnectionStatus oldStatus, JPPFClientConnectionStatus newStatus) {
        ClientConnectionStatusListener[] array;
        if (oldStatus == newStatus) {
            return;
        }
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            array = this.listenersArray;
        }
        for (ClientConnectionStatusListener listener : array) {
            listener.statusChanged(event);
        }
    }

    public JPPFFuture<?> submit(ClientTaskBundle bundle) {
        this.setStatus(JPPFClientConnectionStatus.EXECUTING);
        JPPFFutureTask task = new JPPFFutureTask(new LocalRunnable(this.getBundler(), bundle), null){

            public boolean cancel(boolean mayInterruptIfRunning) {
                if (super.cancel(mayInterruptIfRunning)) {
                    try {
                        ChannelWrapperLocal.this.executionManager.cancelAllTasks(true, false);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }
                return false;
            }
        };
        bundle.jobDispatched(this, (Future<?>)task);
        this.executor.execute((Runnable)task);
        return task;
    }

    public boolean isLocal() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[status=").append((Object)this.status);
        sb.append(", connectionUuid='").append(this.connectionUuid).append('\'');
        sb.append(']');
        return sb.toString();
    }

    public SocketWrapper getSocketWrapper() {
        return null;
    }

    public void setSocketWrapper(SocketWrapper socketWrapper) {
    }

    public void stopNode() {
        this.setStatus(JPPFClientConnectionStatus.DISCONNECTED);
        this.executionManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXServer getJmxServer() throws Exception {
        ChannelWrapperLocal channelWrapperLocal = this;
        synchronized (channelWrapperLocal) {
            if (jmxServer == null || jmxServer.isStopped()) {
                boolean ssl = JPPFConfiguration.getProperties().getBoolean("jppf.ssl.enabled", false);
                jmxServer = JMXServerFactory.createServer((String)this.getUuid(), (boolean)ssl);
                jmxServer.start(this.getClass().getClassLoader());
                System.out.println("JPPF Node management initialized");
            }
        }
        return jmxServer;
    }

    public LifeCycleEventHandler getLifeCycleEventHandler() {
        return this.lifeCycleEventHandler;
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing " + this);
        }
        super.close();
        try {
            this.stopNode();
        }
        finally {
            List<ClientConnectionStatusListener> list = this.listeners;
            synchronized (list) {
                this.listeners.clear();
            }
        }
    }

    private class LocalRunnable
    implements Runnable {
        private final ClientTaskBundle bundle;
        private final Bundler bundler;

        public LocalRunnable(Bundler bundler, ClientTaskBundle bundle) {
            this.bundler = bundler;
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception exception = null;
            List<JPPFTask> tasks = this.bundle.getTasksL();
            try {
                long start = System.nanoTime();
                DataProvider dataProvider = this.bundle.getJob().getDataProvider();
                for (JPPFTask task : tasks) {
                    task.setDataProvider(dataProvider);
                }
                ChannelWrapperLocal.this.executionManager.execute((JPPFTaskBundle)this.bundle, tasks);
                this.bundle.resultsReceived(tasks);
                double elapsed = System.nanoTime() - start;
                this.bundler.feedback(tasks.size(), elapsed);
                this.bundle.taskCompleted(exception);
                ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            }
            catch (Throwable t) {
                try {
                    log.error(t.getMessage(), t);
                    exception = t instanceof Exception ? (Exception)t : new JPPFException(t);
                    this.bundle.resultsReceived(t);
                    this.bundle.taskCompleted(exception);
                    ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                }
                catch (Throwable throwable) {
                    this.bundle.taskCompleted(exception);
                    ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                    this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
                    throw throwable;
                }
                this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
            }
            this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
        }
    }
}

