/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorChannelStatusEvent;
import org.jppf.execute.ExecutorChannelStatusListener;
import org.jppf.execute.ExecutorStatus;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.ContextAwareness;
import org.jppf.server.scheduler.bundle.JPPFContext;
import org.jppf.server.scheduler.bundle.NodeAwareness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelWrapper<T>
implements ExecutorChannel<ClientTaskBundle> {
    private static Logger log = LoggerFactory.getLogger(ChannelWrapper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private Bundler bundler = null;
    protected JPPFSystemInformation systemInfo = null;
    protected JPPFManagementInfo managementInfo = null;
    protected ExecutorService executor;
    private final List<ExecutorChannelStatusListener> listenerList = new ArrayList<ExecutorChannelStatusListener>();

    protected ChannelWrapper() {
    }

    public abstract JPPFClientConnectionStatus getStatus();

    public ExecutorStatus getExecutionStatus() {
        switch (this.getStatus()) {
            case ACTIVE: {
                return ExecutorStatus.ACTIVE;
            }
            case FAILED: {
                return ExecutorStatus.FAILED;
            }
            case EXECUTING: {
                return ExecutorStatus.EXECUTING;
            }
        }
        return ExecutorStatus.DISABLED;
    }

    public abstract void addClientConnectionStatusListener(ClientConnectionStatusListener var1);

    public abstract void removeClientConnectionStatusListener(ClientConnectionStatusListener var1);

    public Bundler getBundler() {
        return this.bundler;
    }

    public boolean checkBundler(Bundler serverBundler, JPPFContext jppfContext) {
        if (serverBundler == null) {
            throw new IllegalArgumentException("serverBundler is null");
        }
        if (this.bundler == null || this.bundler.getTimestamp() < serverBundler.getTimestamp()) {
            if (this.bundler != null) {
                this.bundler.dispose();
                if (this.bundler instanceof ContextAwareness) {
                    ((ContextAwareness)this.bundler).setJPPFContext(null);
                }
            }
            this.bundler = serverBundler.copy();
            if (this.bundler instanceof ContextAwareness) {
                ((ContextAwareness)this.bundler).setJPPFContext(jppfContext);
            }
            this.bundler.setup();
            if (this.bundler instanceof NodeAwareness) {
                ((NodeAwareness)this.bundler).setNodeConfiguration(this.systemInfo);
            }
            return true;
        }
        return false;
    }

    public JPPFSystemInformation getSystemInformation() {
        if (traceEnabled) {
            log.trace("getting system info for " + this + ", jppf.channel.local=" + this.systemInfo.getJppf().getProperty("jppf.channel.local") + ", isLocal()=" + this.isLocal());
        }
        return this.systemInfo;
    }

    public void setSystemInformation(JPPFSystemInformation systemInfo) {
        if (systemInfo != null) {
            systemInfo.getJppf().setProperty("jppf.channel.local", String.valueOf(this.isLocal()));
            this.systemInfo = systemInfo;
            if (traceEnabled) {
                log.trace("setting system info for " + this + ", jppf.channel.local=" + this.systemInfo.getJppf().getProperty("jppf.channel.local") + ", isLocal()=" + this.isLocal());
            }
        } else if (traceEnabled) {
            Exception e = new Exception("call stack for setSystemInfo(null)");
            log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public JPPFManagementInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(JPPFManagementInfo managementInfo) {
        if (managementInfo != null) {
            this.managementInfo = managementInfo;
        }
    }

    public void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public Object getMonitor() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<ExecutorChannelStatusListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<ExecutorChannelStatusListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireExecutionStatusChanged(ExecutorStatus oldValue, ExecutorStatus newValue) {
        ExecutorChannelStatusListener[] listeners;
        if (oldValue == newValue) {
            return;
        }
        List<ExecutorChannelStatusListener> list = this.listenerList;
        synchronized (list) {
            listeners = this.listenerList.toArray(new ExecutorChannelStatusListener[this.listenerList.size()]);
        }
        ExecutorChannelStatusEvent event = new ExecutorChannelStatusEvent((Object)this, oldValue, newValue);
        for (ExecutorChannelStatusListener listener : listeners) {
            listener.executionStatusChanged(event);
        }
    }
}

