/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.JPPFException;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.socket.SocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServerConnectionHandler
extends AbstractClientConnectionHandler {
    private static Logger log = LoggerFactory.getLogger(TaskServerConnectionHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public TaskServerConnectionHandler(JPPFClientConnection owner, String host, int port) {
        super(owner, owner.getName() + " - TasksServer");
        this.host = host;
        this.port = port;
    }

    @Override
    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }

    @Override
    public void init() throws Exception {
        try {
            if (((AbstractJPPFClientConnection)this.owner).closed) {
                throw new IllegalStateException("this task server connection is closed");
            }
            this.setStatus(JPPFClientConnectionStatus.CONNECTING);
            if (this.socketClient == null) {
                this.initSocketClient();
            }
            String msg = "[client: " + this.name + "] Attempting connection to the JPPF task server at " + this.host + ':' + this.port;
            System.out.println(msg);
            if (debugEnabled) {
                log.debug(msg);
            }
            this.socketInitializer.initializeSocket(this.socketClient);
            if (!this.socketInitializer.isSuccessful()) {
                throw new JPPFException('[' + this.name + "] Could not reconnect to the JPPF task server");
            }
            if (this.owner.isSSL()) {
                this.createSSLConnection();
            }
            if (debugEnabled) {
                log.debug("sending JPPF identifier");
            }
            this.socketClient.writeInt(65530);
            JPPFTaskBundle bundle = ((AbstractJPPFClientConnection)this.owner).sendHandshakeJob();
            msg = "[client: " + this.name + "] Reconnected to the JPPF task server";
            System.out.println(msg);
            if (debugEnabled) {
                log.debug(msg);
            }
            this.setStatus(JPPFClientConnectionStatus.ACTIVE);
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    @Override
    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }
}

