/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobResults;
import org.jppf.client.event.SubmissionStatusEvent;
import org.jppf.client.event.SubmissionStatusListener;
import org.jppf.client.event.TaskResultEvent;
import org.jppf.client.event.TaskResultListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.client.persistence.JobPersistenceException;
import org.jppf.client.submission.SubmissionStatus;
import org.jppf.client.submission.SubmissionStatusHandler;
import org.jppf.server.protocol.JPPFTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFResultCollector
implements TaskResultListener,
SubmissionStatusHandler {
    private static Logger log = LoggerFactory.getLogger(JPPFResultCollector.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected int count;
    protected JobResults jobResults;
    protected List<JPPFTask> results = null;
    protected JPPFJob job = null;
    private SubmissionStatus status = SubmissionStatus.SUBMITTED;
    private final List<SubmissionStatusListener> listeners = new ArrayList<SubmissionStatusListener>();

    protected JPPFResultCollector() {
    }

    public JPPFResultCollector(JPPFJob job) {
        this.job = job;
        this.count = job.getTasks().size();
        this.jobResults = job.getResults();
    }

    public JPPFResultCollector(int count) {
        this.count = count;
        this.jobResults = new JobResults();
    }

    @Override
    public synchronized void resultsReceived(TaskResultEvent event) {
        Throwable t = event.getThrowable();
        List<JPPFTask> tasks = event.getTaskList();
        if (tasks != null) {
            this.jobResults.putResults(tasks);
            if (debugEnabled) {
                log.debug("Received results for " + tasks.size() + " tasks, pendingCount = " + (this.count - this.jobResults.size()));
            }
            JobPersistence pm = this.job.getPersistenceManager();
            if (this.job != null && pm != null) {
                try {
                    pm.storeJob(pm.computeKey(this.job), this.job, tasks);
                }
                catch (JobPersistenceException e) {
                    log.error(e.getMessage(), (Throwable)((Object)e));
                }
            }
        } else if (debugEnabled) {
            log.debug("received throwable '" + t.getClass().getName() + ": " + t.getMessage() + "', resetting this result collector");
        }
        this.notifyAll();
    }

    public synchronized List<JPPFTask> waitForResults() {
        return this.waitForResults(Long.MAX_VALUE);
    }

    public synchronized List<JPPFTask> waitForResults(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("wait time cannot be negative");
        }
        if (log.isTraceEnabled()) {
            log.trace("timeout = " + millis + ", pendingCount = " + (this.count - this.jobResults.size()));
        }
        long timeout = millis > 0L ? millis : Long.MAX_VALUE;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (elapsed < timeout && this.getStatus() != SubmissionStatus.COMPLETE) {
            try {
                if (elapsed >= timeout) {
                    return null;
                }
                this.wait(timeout - elapsed);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            elapsed = System.currentTimeMillis() - start;
            if (!log.isTraceEnabled()) continue;
            log.trace("elapsed = " + elapsed + ", millis = " + timeout);
        }
        if (log.isTraceEnabled()) {
            log.trace("elapsed = " + elapsed);
        }
        return this.results;
    }

    public List<JPPFTask> getResults() {
        return this.results;
    }

    protected void buildResults() {
        this.results = new ArrayList<JPPFTask>(this.jobResults.getAll());
    }

    @Override
    public synchronized SubmissionStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStatus(SubmissionStatus newStatus) {
        if (newStatus == this.status) {
            return;
        }
        if (debugEnabled) {
            log.debug("submission [" + this.getId() + "] status changing from '" + (Object)((Object)this.status) + "' to '" + (Object)((Object)newStatus) + "'");
        }
        this.status = newStatus;
        try {
            if (newStatus == SubmissionStatus.COMPLETE) {
                this.buildResults();
                this.onComplete();
            }
        }
        finally {
            this.notifyAll();
            this.fireStatusChangeEvent(newStatus);
        }
    }

    protected void onComplete() {
    }

    public String getId() {
        return this.job == null ? "no-id" : this.job.getUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubmissionStatusListener(SubmissionStatusListener listener) {
        List<SubmissionStatusListener> list = this.listeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("submission [" + this.getId() + "] adding status listener " + listener);
            }
            if (listener != null) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubmissionStatusListener(SubmissionStatusListener listener) {
        List<SubmissionStatusListener> list = this.listeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("submission [" + this.getId() + "] removing status listener " + listener);
            }
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChangeEvent(SubmissionStatus newStatus) {
        List<SubmissionStatusListener> list = this.listeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("submission [" + this.getId() + "] fire status changed event for '" + (Object)((Object)newStatus) + "'");
            }
            if (!this.listeners.isEmpty()) {
                SubmissionStatusEvent event = new SubmissionStatusEvent(this.getId(), newStatus);
                for (SubmissionStatusListener listener : this.listeners) {
                    listener.submissionStatusChanged(event);
                }
            }
        }
    }
}

