/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JPPFMulticastReceiverThread
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JPPFMulticastReceiverThread.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final Map<String, Set<JPPFConnectionInformation>> infoMap = new HashMap<String, Set<JPPFConnectionInformation>>();
    private final AtomicInteger count = new AtomicInteger(0);
    private final boolean acceptMultipleInterfaces;
    private final ConnectionHandler connectionHandler;
    private final IPFilter ipFilter;
    private Thread runningThread = null;

    JPPFMulticastReceiverThread(ConnectionHandler connectionHandler, IPFilter ipFilter, boolean acceptMultipleInterfaces) {
        if (connectionHandler == null) {
            throw new IllegalArgumentException("connectionHandler is null");
        }
        this.connectionHandler = connectionHandler;
        this.ipFilter = ipFilter;
        this.acceptMultipleInterfaces = acceptMultipleInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.runningThread = Thread.currentThread();
        JPPFMulticastReceiver receiver = null;
        try {
            receiver = new JPPFMulticastReceiver(this.ipFilter);
            while (!this.isStopped()) {
                JPPFConnectionInformation info = receiver.receive();
                JPPFMulticastReceiverThread jPPFMulticastReceiverThread = this;
                synchronized (jPPFMulticastReceiverThread) {
                    if (info != null && !this.hasConnectionInformation(info)) {
                        if (debugEnabled) {
                            log.debug("Found connection information: " + info);
                        }
                        this.addConnectionInformation(info);
                        this.onNewConnection("driver-" + this.count.incrementAndGet(), info);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (receiver != null) {
                receiver.setStopped(true);
            }
        }
    }

    protected synchronized void onNewConnection(String name, JPPFConnectionInformation info) {
        this.connectionHandler.onNewConnection(name, info);
    }

    private boolean hasConnectionInformation(JPPFConnectionInformation info) {
        if (this.acceptMultipleInterfaces) {
            Set<JPPFConnectionInformation> set = this.infoMap.get(info.uuid);
            if (set == null) {
                return false;
            }
            return set.contains(info);
        }
        return this.infoMap.get(info.uuid) != null;
    }

    public synchronized void addConnectionInformation(JPPFConnectionInformation info) {
        Set<JPPFConnectionInformation> set = this.infoMap.get(info.uuid);
        if (set == null) {
            set = new HashSet<JPPFConnectionInformation>();
            this.infoMap.put(info.uuid, set);
        }
        set.add(info);
    }

    public synchronized boolean removeConnectionInformation(String uuid) {
        return this.infoMap.remove(uuid) != null;
    }

    public synchronized boolean removeConnectionInformation(JPPFConnectionInformation info) {
        if (this.acceptMultipleInterfaces) {
            Set<JPPFConnectionInformation> set = this.infoMap.get(info.uuid);
            return set != null && set.remove(info);
        }
        return this.infoMap.remove(info.uuid) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setStopped(true);
        if (this.runningThread != null) {
            block6: {
                try {
                    this.runningThread.interrupt();
                }
                catch (Exception e) {
                    if (!debugEnabled) break block6;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            this.runningThread = null;
            JPPFMulticastReceiverThread jPPFMulticastReceiverThread = this;
            synchronized (jPPFMulticastReceiverThread) {
                this.infoMap.clear();
            }
        }
    }

    public static interface ConnectionHandler {
        public void onNewConnection(String var1, JPPFConnectionInformation var2);
    }
}

