/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jppf.JPPFException;
import org.jppf.client.JobResults;
import org.jppf.client.event.JobEvent;
import org.jppf.client.event.JobListener;
import org.jppf.client.event.TaskResultListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.execute.ExecutorChannel;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.protocol.JPPFJobClientSLA;
import org.jppf.server.protocol.JPPFJobMetadata;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFUuid;

public class JPPFJob
implements Serializable,
JPPFDistributedJob {
    private static final long serialVersionUID = 1L;
    private final List<JPPFTask> tasks = new ArrayList<JPPFTask>();
    private DataProvider dataProvider = null;
    private transient TaskResultListener resultsListener = null;
    private boolean blocking = true;
    private String name = null;
    private final String uuid;
    private JobSLA jobSLA = new JPPFJobSLA();
    private JobClientSLA jobClientSLA = new JPPFJobClientSLA();
    private JobMetadata jobMetadata = new JPPFJobMetadata();
    private final JobResults results = new JobResults();
    private transient List<JobListener> listeners = new LinkedList<JobListener>();
    private transient JobPersistence<?> persistenceManager = null;

    public JPPFJob() {
        this(JPPFUuid.normalUUID());
    }

    public JPPFJob(String jobUuid) {
        this.uuid = jobUuid == null ? JPPFUuid.normalUUID() : jobUuid;
        this.name = jobUuid == null ? this.uuid : jobUuid;
    }

    public JPPFJob(DataProvider dataProvider) {
        this(dataProvider, null, true, null);
    }

    public JPPFJob(DataProvider dataProvider, JobSLA jobSLA) {
        this(dataProvider, jobSLA, true, null);
    }

    public JPPFJob(TaskResultListener resultsListener) {
        this(null, null, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, TaskResultListener resultsListener) {
        this(dataProvider, null, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JobSLA jobSLA, TaskResultListener resultsListener) {
        this(dataProvider, jobSLA, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JobSLA jobSLA, boolean blocking, TaskResultListener resultsListener) {
        this(dataProvider, jobSLA, null, blocking, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JobSLA jobSLA, JPPFJobMetadata jobMetadata, boolean blocking, TaskResultListener resultsListener) {
        this();
        this.dataProvider = dataProvider;
        if (jobSLA != null) {
            this.jobSLA = jobSLA;
        }
        if (jobMetadata != null) {
            this.jobMetadata = jobMetadata;
        }
        this.resultsListener = resultsListener;
        this.blocking = blocking;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JPPFTask> getTasks() {
        return this.tasks;
    }

    public synchronized List<JPPFTask> getPendingTasks() {
        LinkedList<JPPFTask> list = new LinkedList<JPPFTask>();
        for (JPPFTask t : this.tasks) {
            if (this.results.hasResult(t.getPosition())) continue;
            list.add(t);
        }
        return list;
    }

    public JPPFTask addTask(Object taskObject, Object ... args) throws JPPFException {
        Object jppfTask = null;
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        jppfTask = taskObject instanceof JPPFTask ? (JPPFTask)taskObject : new JPPFAnnotatedTask(taskObject, args);
        this.tasks.add((JPPFTask)jppfTask);
        jppfTask.setPosition(this.tasks.size() - 1);
        return jppfTask;
    }

    public JPPFTask addTask(String method, Object taskObject, Object ... args) throws JPPFException {
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        JPPFAnnotatedTask jppfTask = new JPPFAnnotatedTask(taskObject, method, args);
        this.tasks.add((JPPFTask)jppfTask);
        jppfTask.setPosition(this.tasks.size() - 1);
        return jppfTask;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public TaskResultListener getResultListener() {
        return this.resultsListener;
    }

    public void setResultListener(TaskResultListener resultsListener) {
        this.resultsListener = resultsListener;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public JobSLA getSLA() {
        return this.jobSLA;
    }

    public void setSLA(JobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    public JobClientSLA getClientSLA() {
        return this.jobClientSLA;
    }

    public void setClientSLA(JobClientSLA jobClientSLA) {
        this.jobClientSLA = jobClientSLA;
    }

    public JobMetadata getMetadata() {
        return this.jobMetadata;
    }

    public void setMetadata(JobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JPPFJob)) {
            return false;
        }
        JPPFJob other = (JPPFJob)obj;
        return this.uuid == null ? other.uuid == null : this.uuid.equals(other.uuid);
    }

    public JobResults getResults() {
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireJobEvent(JobEvent.Type type, ExecutorChannel channel, List<JPPFTask> tasks) {
        JobEvent event = new JobEvent(this, channel, tasks);
        List<JobListener> list = this.listeners;
        synchronized (list) {
            for (JobListener listener : this.listeners) {
                switch (type) {
                    case JOB_START: {
                        listener.jobStarted(event);
                        break;
                    }
                    case JOB_END: {
                        listener.jobEnded(event);
                        break;
                    }
                    case JOB_DISPATCH: {
                        listener.jobDispatched(event);
                        break;
                    }
                    case JOB_RETURN: {
                        listener.jobReturned(event);
                    }
                }
            }
        }
    }

    public <T> JobPersistence<T> getPersistenceManager() {
        return this.persistenceManager;
    }

    public <T> void setPersistenceManager(JobPersistence<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    protected Object readResolve() {
        this.listeners = new LinkedList<JobListener>();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.name);
        sb.append(", uuid=").append(this.uuid);
        sb.append(", blocking=").append(this.blocking);
        sb.append(", nbTasks=").append(this.tasks.size());
        sb.append(", nbResults=").append(this.results.size());
        sb.append(", jobSLA=").append(this.jobSLA);
        sb.append(']');
        return sb.toString();
    }
}

