/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFError;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.ClassServerDelegateImpl;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClientConnectionImpl
extends AbstractJPPFClientConnection {
    private static Logger log = LoggerFactory.getLogger(JPPFClientConnectionImpl.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ReentrantLock lock = new ReentrantLock();

    public JPPFClientConnectionImpl(JPPFClient client, String uuid, String name, JPPFConnectionInformation info, boolean ssl) {
        this.client = client;
        this.ssl = ssl;
        this.configure(uuid, name, info.host, ssl ? info.sslServerPorts[0] : info.serverPorts[0], 0, ssl);
        this.jmxPort = ssl ? info.sslManagementPort : info.managementPort;
        this.initializeJmxConnection();
    }

    @Override
    public void init() {
        try {
            if (this.closed) {
                throw new IllegalStateException("this client connection is closed");
            }
            try {
                this.host = InetAddress.getByName(this.host).getHostName();
                this.displayName = this.name + '[' + this.host + ':' + this.port + ']';
                this.getJmxConnection().setHost(this.host);
            }
            catch (UnknownHostException e) {
                this.displayName = this.name;
            }
            this.delegate = new ClassServerDelegateImpl(this, this.client.getUuid(), this.host, this.port);
            this.delegate.addClientConnectionStatusListener(new ClientConnectionStatusListener(){

                @Override
                public void statusChanged(ClientConnectionStatusEvent event) {
                    JPPFClientConnectionImpl.this.delegateStatusChanged(event);
                }
            });
            this.taskServerConnection.addClientConnectionStatusListener(new ClientConnectionStatusListener(){

                @Override
                public void statusChanged(ClientConnectionStatusEvent event) {
                    JPPFClientConnectionImpl.this.taskServerConnectionStatusChanged(event);
                }
            });
            this.connect();
            JPPFClientConnectionStatus status = this.getStatus();
            if (debugEnabled) {
                log.debug("connection [" + this.name + "] status=" + (Object)((Object)status));
            }
            if (this.client.isClosed()) {
                this.close();
            } else if (status == JPPFClientConnectionStatus.ACTIVE || status == JPPFClientConnectionStatus.EXECUTING) {
                this.client.addClientConnection(this);
                if (debugEnabled) {
                    log.debug("connection [" + this.name + "] added to the client pool");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        }
        catch (JPPFError e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    protected void connect() throws Exception {
        this.delegate.init();
        if (!this.delegate.isClosed()) {
            Thread t = new Thread(this.delegate);
            t.setName('[' + this.delegate.getName() + " : class delegate]");
            t.start();
            this.taskServerConnection.init();
        }
    }

    @Override
    public void submit(JPPFJob job) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }
}

