/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.List;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFJob;
import org.jppf.client.JPPFResultCollector;
import org.jppf.client.balancer.SubmissionManagerClient;
import org.jppf.client.event.ClientListener;
import org.jppf.client.submission.SubmissionManager;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.server.JPPFStats;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClient
extends AbstractGenericClient {
    private static Logger log = LoggerFactory.getLogger(JPPFClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public JPPFClient() {
        super(null, JPPFConfiguration.getProperties(), new ClientListener[0]);
    }

    public JPPFClient(ClientListener ... listeners) {
        super(null, JPPFConfiguration.getProperties(), listeners);
    }

    public JPPFClient(String uuid) {
        super(uuid, JPPFConfiguration.getProperties(), new ClientListener[0]);
    }

    public JPPFClient(String uuid, ClientListener ... listeners) {
        super(uuid, JPPFConfiguration.getProperties(), listeners);
    }

    @Override
    protected TypedProperties initConfig(Object configuration) {
        return (TypedProperties)configuration;
    }

    @Override
    protected AbstractJPPFClientConnection createConnection(String uuid, String name, JPPFConnectionInformation info, boolean ssl) {
        return new JPPFClientConnectionImpl(this, uuid, name, info, ssl);
    }

    @Override
    public List<JPPFTask> submit(JPPFJob job) throws Exception {
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        if (job.getTasks().isEmpty()) {
            throw new IllegalArgumentException("job cannot be empty");
        }
        if (job.getResultListener() == null || job.isBlocking() && !(job.getResultListener() instanceof JPPFResultCollector)) {
            job.setResultListener(new JPPFResultCollector(job));
        }
        SubmissionManager submissionManager = this.getSubmissionManager();
        submissionManager.submitJob(job);
        if (job.isBlocking()) {
            JPPFResultCollector collector = (JPPFResultCollector)job.getResultListener();
            return collector.waitForResults();
        }
        return null;
    }

    public JPPFStats requestStatistics() throws Exception {
        JPPFClientConnectionImpl conn = (JPPFClientConnectionImpl)this.getClientConnection(true);
        return conn == null ? null : conn.getJmxConnection().statistics();
    }

    @Override
    protected SubmissionManager createSubmissionManager() {
        SubmissionManagerClient submissionManager = null;
        try {
            submissionManager = new SubmissionManagerClient(this);
        }
        catch (Exception e) {
            log.error("Can't initialize Submission Manager", (Throwable)e);
        }
        return submissionManager;
    }

    @Override
    public boolean cancelJob(String jobId) throws Exception {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobId is blank");
        }
        SubmissionManager submissionManager = this.getSubmissionManager();
        if (submissionManager instanceof SubmissionManagerClient) {
            return ((SubmissionManagerClient)submissionManager).cancelJob(jobId);
        }
        return super.cancelJob(jobId);
    }
}

