/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.JPPFClientConnection;

class ClientPool {
    private final int priority;
    private int lastUsedIndex = 0;
    private final List<JPPFClientConnection> clientList = new ArrayList<JPPFClientConnection>();

    public ClientPool(int priority) {
        this.priority = priority;
    }

    public JPPFClientConnection nextClient() {
        if (this.clientList.isEmpty()) {
            return null;
        }
        ++this.lastUsedIndex;
        this.lastUsedIndex %= this.clientList.size();
        return this.clientList.get(this.getLastUsedIndex());
    }

    public boolean isEmpty() {
        return this.clientList.isEmpty();
    }

    public int size() {
        return this.clientList.size();
    }

    public boolean add(JPPFClientConnection client) {
        return this.clientList.add(client);
    }

    public boolean remove(JPPFClientConnection client) {
        if (this.clientList.remove(client)) {
            if (this.lastUsedIndex >= this.clientList.size() && this.lastUsedIndex > 0) {
                --this.lastUsedIndex;
            }
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getLastUsedIndex() {
        return this.lastUsedIndex;
    }
}

