/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.JPPFException;
import org.jppf.client.AbstractClassServerDelegate;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassServerDelegateImpl
extends AbstractClassServerDelegate {
    private static Logger log = LoggerFactory.getLogger(ClassServerDelegateImpl.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ClassServerDelegateImpl(JPPFClientConnection owner, String uuid, String host, int port) throws Exception {
        super(owner);
        this.clientUuid = uuid;
        this.host = host;
        this.port = port;
    }

    @Override
    public final void init() throws Exception {
        try {
            if (((AbstractJPPFClientConnection)this.owner).closed) {
                throw new IllegalStateException("this task server connection is closed");
            }
            this.handshakeDone = false;
            this.socketInitializer.setName('[' + this.getName() + " - delegate] ");
            this.setStatus(JPPFClientConnectionStatus.CONNECTING);
            if (this.socketClient == null) {
                this.initSocketClient();
            }
            String msg = "[client: " + this.getName() + "] Attempting connection to the class server at " + this.host + ':' + this.port;
            System.out.println(msg);
            log.info(msg);
            this.socketInitializer.initializeSocket(this.socketClient);
            if (!this.socketInitializer.isSuccessful() && !this.socketInitializer.isClosed()) {
                throw new JPPFException('[' + this.getName() + "] Could not reconnect to the class server");
            }
            if (this.owner.isSSL()) {
                this.createSSLConnection();
            }
            if (!this.socketInitializer.isClosed()) {
                msg = "[client: " + this.getName() + "] Reconnected to the class server";
                System.out.println(msg);
                log.info(msg);
                this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            }
        }
        catch (Exception e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setUncaughtExceptionHandler(this);
            while (!this.stop) {
                try {
                    if (!this.handshakeDone) {
                        this.handshake();
                    }
                    this.processNextRequest();
                }
                catch (Exception e) {
                    if (this.closed) continue;
                    log.warn('[' + this.getName() + "] caught " + e + ", will re-initialise ...", (Throwable)e);
                    this.init();
                    if (!debugEnabled) continue;
                    log.debug('[' + this.getName() + "] : successfully initialized");
                }
            }
        }
        catch (Exception e) {
            log.error('[' + this.getName() + "] " + e.getMessage(), (Throwable)e);
            this.close();
        }
    }

    @Override
    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }
}

