/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.nio.channels.AsynchronousCloseException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFException;
import org.jppf.caching.JPPFHashMapCache;
import org.jppf.caching.JPPFMapCache;
import org.jppf.classloader.NonDelegatingClassLoader;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFJob;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.IOHelper;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.ObjectSerializerImpl;
import org.jppf.utils.Pair;
import org.jppf.utils.SerializationHelper;
import org.jppf.utils.TraversalList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJPPFClientConnection
implements JPPFClientConnection {
    private static Logger log = LoggerFactory.getLogger(BaseJPPFClientConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected static String SERIALIZATION_HELPER_IMPL = "org.jppf.utils.SerializationHelperImpl";
    private static Lock lock = new ReentrantLock();
    private static final boolean SEQUENTIAL_DESERIALIZATION = JPPFConfiguration.getProperties().getBoolean("jppf.sequential.deserialization", false);
    protected TaskServerConnectionHandler taskServerConnection = null;
    protected ClassServerDelegate delegate = null;
    protected String uuid = null;
    protected String host = null;
    protected int port = -1;
    protected String name = null;
    protected AbstractGenericClient client = null;
    protected final String connectionUuid = new JPPFUuid().toString();
    protected String serializationHelperClassName = JPPFConfiguration.getProperties().getString("jppf.serialization.helper.class", SERIALIZATION_HELPER_IMPL);
    protected final JPPFMapCache<ClassLoader, NonDelegatingClassLoader> ndclCache = new JPPFHashMapCache();

    @Override
    public abstract void init();

    public void sendTasks(ClassLoader cl, JPPFTaskBundle header, JPPFJob job) throws Exception {
        ObjectSerializer ser = this.makeHelper(cl).getSerializer();
        int count = job.getTasks().size() - job.getResults().size();
        TraversalList uuidPath = new TraversalList();
        uuidPath.add((Object)this.client.getUuid());
        header.setUuidPath(uuidPath);
        header.setTaskCount(count);
        header.setName(job.getName());
        header.setUuid(job.getUuid());
        header.setSLA(job.getSLA());
        header.setMetadata(job.getMetadata());
        if (debugEnabled) {
            log.debug("[client: " + this.name + "] sending job " + header);
        }
        SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
        IOHelper.sendData((SocketWrapper)socketClient, (Object)header, (ObjectSerializer)ser);
        IOHelper.sendData((SocketWrapper)socketClient, (Object)job.getDataProvider(), (ObjectSerializer)ser);
        for (JPPFTask task : job.getTasks()) {
            if (job.getResults().hasResult(task.getPosition())) continue;
            IOHelper.sendData((SocketWrapper)socketClient, (Object)task, (ObjectSerializer)ser);
        }
        socketClient.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFTaskBundle sendHandshakeJob() throws Exception {
        JPPFTaskBundle header = new JPPFTaskBundle();
        ObjectSerializerImpl ser = new ObjectSerializerImpl();
        TraversalList uuidPath = new TraversalList();
        uuidPath.add((Object)this.client.getUuid());
        header.setUuidPath(uuidPath);
        if (debugEnabled) {
            log.debug("[client: " + this.name + "] sending handshake job, uuidPath=" + uuidPath);
        }
        header.setRequestUuid(new JPPFUuid().toString());
        header.setName("handshake job");
        header.setUuid("handshake job");
        header.setParameter((Object)"connection.uuid", (Object)this.connectionUuid);
        SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
        IOHelper.sendData((SocketWrapper)socketClient, (Object)header, (ObjectSerializer)ser);
        IOHelper.sendData((SocketWrapper)socketClient, null, (ObjectSerializer)ser);
        socketClient.flush();
        String name = this.getSerializationHelperClassName();
        try {
            this.setSerializationHelperClassName(SERIALIZATION_HELPER_IMPL);
            JPPFTaskBundle jPPFTaskBundle = (JPPFTaskBundle)this.receiveBundleAndResults().first();
            return jPPFTaskBundle;
        }
        finally {
            this.setSerializationHelperClassName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<JPPFTaskBundle, List<JPPFTask>> receiveBundleAndResults() throws Exception {
        LinkedList<JPPFTask> taskList = new LinkedList<JPPFTask>();
        JPPFTaskBundle bundle = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
            ObjectSerializer ser = this.makeHelper(cl).getSerializer();
            bundle = (JPPFTaskBundle)IOHelper.unwrappedData((SocketWrapper)socketClient, (ObjectSerializer)ser);
            int count = bundle.getTaskCount();
            if (debugEnabled) {
                log.debug("received bundle " + bundle);
            }
            if (SEQUENTIAL_DESERIALIZATION) {
                lock.lock();
            }
            try {
                for (int i = 0; i < count; ++i) {
                    taskList.add((JPPFTask)IOHelper.unwrappedData((SocketWrapper)socketClient, (ObjectSerializer)ser));
                }
            }
            finally {
                if (SEQUENTIAL_DESERIALIZATION) {
                    lock.unlock();
                }
            }
            Throwable t = (Throwable)bundle.getParameter((Object)BundleParameter.NODE_EXCEPTION_PARAM);
            if (t != null) {
                if (debugEnabled) {
                    log.debug("server returned exception parameter in the header for job '" + bundle.getName() + "' : " + t);
                }
                Exception e = t instanceof Exception ? (Exception)t : new JPPFException(t);
                for (JPPFTask task : taskList) {
                    task.setException(e);
                }
            }
            return new Pair((Object)bundle, taskList);
        }
        catch (AsynchronousCloseException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public List<JPPFTask> receiveResults() throws Exception {
        return (List)this.receiveBundleAndResults().second();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFTask> receiveResults(ClassLoader cl) throws Exception {
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        List<JPPFTask> results = null;
        try {
            results = this.receiveResults();
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
        return results;
    }

    protected SerializationHelper makeHelper() throws Exception {
        return this.makeHelper(null);
    }

    protected SerializationHelper makeHelper(ClassLoader classLoader) throws Exception {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        String helperClassName = this.getSerializationHelperClassName();
        Class clazz = null;
        NonDelegatingClassLoader ndCl = (NonDelegatingClassLoader)this.ndclCache.get((Object)cl);
        if (ndCl == null) {
            final ClassLoader parent = cl;
            PrivilegedAction<NonDelegatingClassLoader> pa = new PrivilegedAction<NonDelegatingClassLoader>(){

                @Override
                public NonDelegatingClassLoader run() {
                    return new NonDelegatingClassLoader(null, parent);
                }
            };
            ndCl = AccessController.doPrivileged(pa);
            this.ndclCache.put((Object)cl, (Object)ndCl);
            try {
                clazz = ndCl.loadClassDirect(helperClassName);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                clazz = ndCl.loadClass(helperClassName);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            cl = this.getClass().getClassLoader();
            clazz = cl.loadClass(helperClassName);
        }
        return (SerializationHelper)clazz.newInstance();
    }

    protected String getSerializationHelperClassName() {
        return this.serializationHelperClassName;
    }

    protected void setSerializationHelperClassName(String name) {
        this.serializationHelperClassName = name;
    }

    @Override
    public abstract List<JPPFJob> close();

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract SocketInitializer createSocketInitializer();

    public TaskServerConnectionHandler getTaskServerConnection() {
        return this.taskServerConnection;
    }

    public ClassServerDelegate getDelegate() {
        return this.delegate;
    }

    public AbstractGenericClient getClient() {
        return this.client;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getConnectionUuid() {
        return this.connectionUuid;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

