/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jppf.client.BaseJPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClientConnection
extends BaseJPPFClientConnection {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClientConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected int priority = 0;
    protected AtomicReference<JPPFClientConnectionStatus> status = new AtomicReference<JPPFClientConnectionStatus>(JPPFClientConnectionStatus.CREATED);
    protected final List<ClientConnectionStatusListener> listeners = new LinkedList<ClientConnectionStatusListener>();
    protected ClientConnectionStatusListener[] listenersArray;
    protected JPPFJob job = null;
    protected boolean closed = false;
    protected String displayName;
    protected boolean ssl = false;
    private JPPFSystemInformation systemInfo = null;
    protected JMXDriverConnectionWrapper jmxConnection = null;
    protected int jmxPort = -1;
    protected TypedProperties props = null;

    protected void configure(String uuid, String name, String host, int driverPort, int priority, boolean ssl) {
        this.uuid = uuid;
        this.host = host;
        this.port = driverPort;
        this.priority = priority;
        this.name = name;
        this.ssl = ssl;
        this.displayName = name;
        this.taskServerConnection = new TaskServerConnectionHandler(this, this.host, this.port);
    }

    @Override
    public abstract void init();

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        JPPFClientConnectionStatus oldStatus = this.getStatus();
        if (status != oldStatus) {
            if (debugEnabled) {
                log.debug("connection '" + this.name + "' status changing from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)status));
            }
            this.status.set(status);
            this.fireStatusChanged(oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            this.listenersArray = this.listeners.toArray(new ClientConnectionStatusListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            this.listenersArray = this.listeners.toArray(new ClientConnectionStatusListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChanged(JPPFClientConnectionStatus oldStatus) {
        ClientConnectionStatusListener[] array;
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            array = this.listenersArray;
        }
        for (ClientConnectionStatusListener listener : array) {
            listener.statusChanged(event);
        }
    }

    public String toString() {
        return this.displayName + " : " + this.status;
    }

    @Override
    protected abstract SocketInitializer createSocketInitializer();

    public JPPFJob getCurrentJob() {
        return this.job;
    }

    public void setCurrentJob(JPPFJob currentExecution) {
        this.job = currentExecution;
    }

    public boolean cancelJob(String jobId) throws Exception {
        JMXDriverConnectionWrapper jmxConnection = this.getJmxConnection();
        if (jmxConnection != null && jmxConnection.isConnected()) {
            jmxConnection.cancelJob(jobId);
            return true;
        }
        return false;
    }

    public void delegateStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.taskServerConnection.getStatus();
        this.processStatusChanged(s1, s2);
    }

    public void taskServerConnectionStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.delegate.getStatus();
        this.processStatusChanged(s2, s1);
    }

    protected void processStatusChanged(JPPFClientConnectionStatus delegateStatus, JPPFClientConnectionStatus taskConnectionStatus) {
        if (delegateStatus == JPPFClientConnectionStatus.FAILED) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        } else if (delegateStatus == JPPFClientConnectionStatus.ACTIVE) {
            if (taskConnectionStatus == JPPFClientConnectionStatus.ACTIVE && this.getStatus() != JPPFClientConnectionStatus.ACTIVE) {
                this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            } else if (taskConnectionStatus != this.getStatus()) {
                this.setStatus(taskConnectionStatus);
            }
        } else if (taskConnectionStatus == JPPFClientConnectionStatus.ACTIVE) {
            this.setStatus(delegateStatus);
        } else {
            int n = delegateStatus.compareTo(taskConnectionStatus);
            if (n < 0 && delegateStatus != this.getStatus()) {
                this.setStatus(delegateStatus);
            } else if (taskConnectionStatus != this.getStatus()) {
                this.setStatus(taskConnectionStatus);
            }
        }
    }

    @Override
    public boolean isSSL() {
        return this.ssl;
    }

    public JPPFSystemInformation getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public JPPFTaskBundle sendHandshakeJob() throws Exception {
        JPPFTaskBundle bundle = super.sendHandshakeJob();
        this.systemInfo = (JPPFSystemInformation)bundle.getParameter((Object)BundleParameter.SYSTEM_INFO_PARAM);
        this.uuid = (String)bundle.getParameter((Object)BundleParameter.DRIVER_UUID_PARAM);
        if (debugEnabled) {
            log.debug("got driver uuid: " + this.uuid);
        }
        return bundle;
    }

    public void initializeJmxConnection() {
        this.jmxConnection = new JMXDriverConnectionWrapper(this.host, this.jmxPort, this.ssl);
        this.jmxConnection.connect();
    }

    public JMXDriverConnectionWrapper getJmxConnection() {
        return this.jmxConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JPPFJob> close() {
        if (debugEnabled) {
            log.debug("closing connection " + this);
        }
        List<JPPFJob> list = null;
        List<ClientConnectionStatusListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.clear();
        }
        if (!this.closed) {
            this.closed = true;
            try {
                if (debugEnabled) {
                    log.debug("closing task server connection " + this);
                }
                if (this.taskServerConnection != null) {
                    this.taskServerConnection.close();
                }
                if (debugEnabled) {
                    log.debug("closing class server connection " + this);
                }
                if (this.delegate != null) {
                    this.delegate.close();
                }
                if (debugEnabled) {
                    log.debug("closing jmx connection " + this);
                }
                if (this.jmxConnection != null) {
                    this.jmxConnection.close();
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug('[' + this.name + "] " + e.getMessage(), (Throwable)e);
                }
                log.error('[' + this.name + "] " + e.getMessage());
            }
            if (this.job != null) {
                list = Collections.singletonList(this.job);
            }
        }
        this.ndclCache.clear();
        if (list == null) {
            list = Collections.emptyList();
        }
        if (debugEnabled) {
            log.debug("connection " + this + " closed");
        }
        return list;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

