/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.client.ClientPool;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ClientEvent;
import org.jppf.client.event.ClientListener;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClient
implements ClientConnectionStatusListener {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected int totalTaskCount = 0;
    private final Map<Integer, ClientPool> pools = new TreeMap<Integer, ClientPool>(new DescendingIntegerComparator());
    protected String uuid = null;
    private final List<JPPFClientConnection> allConnections = new LinkedList<JPPFClientConnection>();
    private final List<ClientListener> listeners = new ArrayList<ClientListener>();
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    protected AbstractJPPFClient(String uuid) {
        String string = this.uuid = uuid == null ? new JPPFUuid().toString() : uuid;
        if (debugEnabled) {
            log.debug("Instantiating JPPF client with uuid=" + this.uuid);
        }
    }

    protected abstract void initPools(TypedProperties var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFClientConnection> getAllConnections() {
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList<JPPFClientConnection>(this.allConnections));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAllConnectionsCount() {
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            return this.allConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllConnectionNames() {
        LinkedList<String> names;
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            names = new LinkedList<String>();
            for (JPPFClientConnection c : this.allConnections) {
                names.add(c.getName());
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFClientConnection getClientConnection(String name) {
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            for (JPPFClientConnection c : this.allConnections) {
                if (!c.getName().equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    public JPPFClientConnection getClientConnection() {
        return this.getClientConnection(true, true);
    }

    public JPPFClientConnection getClientConnection(boolean oneAttempt) {
        return this.getClientConnection(oneAttempt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFClientConnection getClientConnection(boolean oneAttempt, boolean anyState) {
        JPPFClientConnection connection = null;
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            while (connection == null && !this.pools.isEmpty()) {
                Iterator<Map.Entry<Integer, ClientPool>> poolIterator = this.pools.entrySet().iterator();
                while (connection == null && poolIterator.hasNext()) {
                    JPPFClientConnection c;
                    Map.Entry<Integer, ClientPool> entry = poolIterator.next();
                    ClientPool pool = entry.getValue();
                    block9: for (int count = 0; connection == null && count < pool.size() && (c = pool.nextClient()) != null; ++count) {
                        switch (c.getStatus()) {
                            case ACTIVE: {
                                connection = c;
                                continue block9;
                            }
                            case FAILED: {
                                pool.remove(c);
                                if (!pool.isEmpty()) continue block9;
                                poolIterator.remove();
                                continue block9;
                            }
                            default: {
                                if (!anyState) continue block9;
                                connection = c;
                            }
                        }
                    }
                }
                if (this.pools.isEmpty()) {
                    log.warn("No more driver connection available for this client");
                }
                if (!oneAttempt) continue;
                break;
            }
        }
        if (debugEnabled && connection != null) {
            log.debug("found client connection \"" + connection + '\"');
        }
        return connection;
    }

    public void initCredentials() throws Exception {
    }

    public abstract List<JPPFTask> submit(JPPFJob var1) throws Exception;

    @Override
    public void statusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnection c = (JPPFClientConnection)event.getClientConnectionStatusHandler();
        if (c.getStatus() == JPPFClientConnectionStatus.FAILED) {
            this.connectionFailed(c);
        }
    }

    protected abstract void connectionFailed(JPPFClientConnection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientConnection(JPPFClientConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        int priority = connection.getPriority();
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            ClientPool pool = this.pools.get(priority);
            if (pool == null) {
                pool = new ClientPool(priority);
                this.pools.put(priority, pool);
            }
            pool.add(connection);
            this.allConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClientConnection(JPPFClientConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        connection.removeClientConnectionStatusListener(this);
        int priority = connection.getPriority();
        Map<Integer, ClientPool> map = this.pools;
        synchronized (map) {
            ClientPool pool = this.pools.get(priority);
            boolean emptyPools = false;
            if (pool != null) {
                pool.remove(connection);
                if (pool.isEmpty()) {
                    this.pools.remove(priority);
                }
                this.allConnections.remove(connection);
                if (this.pools.isEmpty()) {
                    log.error("FATAL ERROR: No more driver connection available for this client");
                    emptyPools = true;
                }
            }
        }
    }

    public void close() {
        List<JPPFClientConnection> list = this.getAllConnections();
        if (debugEnabled) {
            log.debug("closing all connections: " + list);
        }
        for (JPPFClientConnection c : list) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(ClientListener listener) {
        List<ClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(ClientListener listener) {
        List<ClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionFailed(JPPFClientConnection c) {
        ClientEvent event = new ClientEvent(c);
        List<ClientListener> list = this.listeners;
        synchronized (list) {
            for (ClientListener listener : this.listeners) {
                listener.connectionFailed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNewConnection(JPPFClientConnection c) {
        ClientEvent event = new ClientEvent(c);
        List<ClientListener> list = this.listeners;
        synchronized (list) {
            for (ClientListener listener : this.listeners) {
                listener.newConnection(event);
            }
        }
    }

    public void newConnection(JPPFClientConnection c) {
        this.fireNewConnection(c);
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static class DescendingIntegerComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        DescendingIntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 < o2) {
                return 1;
            }
            if (o1 > o2) {
                return -1;
            }
            return 0;
        }
    }
}

