/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jppf.client.AbstractJPPFClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.ConnectionInitializer;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFMulticastReceiverThread;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ClientListener;
import org.jppf.client.submission.SubmissionManager;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.startup.JPPFClientStartupSPI;
import org.jppf.startup.JPPFStartupLoader;
import org.jppf.utils.JPPFThreadFactory;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericClient
extends AbstractJPPFClient {
    private static Logger log = LoggerFactory.getLogger(AbstractGenericClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    protected static final String VALUE_JPPF_DISCOVERY = "jppf_discovery";
    protected ThreadPoolExecutor executor = null;
    private final TypedProperties config;
    protected JPPFMulticastReceiverThread receiverThread = null;
    private final Map<String, ClassLoader> classLoaderMap = new Hashtable<String, ClassLoader>();
    private final Map<String, Set<RegisteredClassLoader>> classLoaderRegistrations = new HashMap<String, Set<RegisteredClassLoader>>();
    private final Map<ClassLoader, String> classLoaderUUIDs = new WeakHashMap<ClassLoader, String>();
    protected boolean sslEnabled = false;
    private SubmissionManager submissionManager;

    public AbstractGenericClient(String uuid, Object configuration, ClientListener ... listeners) {
        super(uuid);
        for (ClientListener listener : listeners) {
            this.addClientListener(listener);
        }
        this.config = this.initConfig(configuration);
        this.sslEnabled = this.config.getBoolean("jppf.ssl.enabled", false);
        log.info("JPPF client starting with sslEnabled = " + this.sslEnabled);
        new JPPFStartupLoader().load(JPPFClientStartupSPI.class);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AbstractGenericClient.this.initPools(AbstractGenericClient.this.config);
            }
        };
        new Thread(r, "InitPools").start();
    }

    public TypedProperties getConfig() {
        return this.config;
    }

    protected abstract TypedProperties initConfig(Object var1);

    @Override
    protected void initPools(TypedProperties config) {
        if (debugEnabled) {
            log.debug("initializing connections");
        }
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, queue, (ThreadFactory)new JPPFThreadFactory("JPPF Client"));
        if (config.getBoolean("jppf.remote.execution.enabled", true)) {
            this.initRemotePools(config);
        }
    }

    private void initRemotePools(final TypedProperties props) {
        try {
            String[] names;
            String discoveryNames;
            boolean initPeers;
            if (props.getBoolean("jppf.discovery.enabled", true)) {
                if (debugEnabled) {
                    log.debug("initializing connections from discovery");
                }
                boolean acceptMultipleInterfaces = props.getBoolean("jppf.discovery.acceptMultipleInterfaces", false);
                this.receiverThread = new JPPFMulticastReceiverThread(new JPPFMulticastReceiverThread.ConnectionHandler(){

                    @Override
                    public void onNewConnection(String name, JPPFConnectionInformation info) {
                        AbstractGenericClient.this.newConnection(name, info, 0, props.getInt("jppf.pool.size", 1), AbstractGenericClient.this.sslEnabled);
                    }
                }, new IPFilter(props), acceptMultipleInterfaces);
                new Thread(this.receiverThread).start();
                initPeers = false;
            } else {
                this.receiverThread = null;
                initPeers = true;
            }
            if (debugEnabled) {
                log.debug("found peers in the configuration");
            }
            if ((discoveryNames = props.getString("jppf.drivers")) == null || "".equals(discoveryNames.trim())) {
                discoveryNames = "default-driver";
            }
            if (debugEnabled) {
                log.debug("list of drivers: " + discoveryNames);
            }
            for (String name : names = discoveryNames.split("\\s")) {
                initPeers |= VALUE_JPPF_DISCOVERY.equals(name);
            }
            if (initPeers) {
                for (String name : names) {
                    if (VALUE_JPPF_DISCOVERY.equals(name)) continue;
                    JPPFConnectionInformation info = new JPPFConnectionInformation();
                    info.host = props.getString(String.format("%s.jppf.server.host", name), "localhost");
                    int port = props.getAndReplaceInt(String.format("%s.jppf.server.port", name), String.format("%s.class.server.port", name), this.sslEnabled ? 11443 : 11111, false);
                    if (!this.sslEnabled) {
                        info.serverPorts = new int[]{port};
                    } else {
                        info.sslServerPorts = new int[]{port};
                    }
                    if (!this.sslEnabled) {
                        info.managementPort = props.getInt(String.format("%s.jppf.management.port", name), 11198);
                    } else {
                        info.sslManagementPort = props.getInt(String.format("%s.jppf.management.port", name), 11198);
                    }
                    int priority = props.getInt(String.format("%s.priority", name), 0);
                    if (this.receiverThread != null) {
                        this.receiverThread.addConnectionInformation(info);
                    }
                    this.newConnection(name, info, priority, props.getInt(name + ".jppf.pool.size", 1), this.sslEnabled);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void newConnection(String name, JPPFConnectionInformation info, int priority, int poolSize, boolean ssl) {
        for (int i = 1; i <= poolSize; ++i) {
            if (this.isClosed()) {
                return;
            }
            AbstractJPPFClientConnection c = this.createConnection(info.uuid, poolSize > 1 ? name + '-' + i : name, info, ssl);
            c.setPriority(priority);
            this.newConnection(c);
        }
    }

    protected abstract AbstractJPPFClientConnection createConnection(String var1, String var2, JPPFConnectionInformation var3, boolean var4);

    @Override
    public void newConnection(JPPFClientConnection c) {
        if (this.isClosed()) {
            return;
        }
        log.info("connection [" + c.getName() + "] created");
        c.addClientConnectionStatusListener(this);
        c.setStatus(JPPFClientConnectionStatus.NEW);
        this.executor.submit(new ConnectionInitializer(c));
        this.fireNewConnection(c);
        if (debugEnabled) {
            log.debug("end of connection [" + c.getName() + "] created");
        }
    }

    @Override
    protected void connectionFailed(JPPFClientConnection c) {
        log.info("Connection [" + c.getName() + "] failed");
        if (this.receiverThread != null) {
            this.receiverThread.removeConnectionInformation(((AbstractJPPFClientConnection)c).getUuid());
        }
        this.removeClientConnection(c);
        this.fireConnectionFailed(c);
    }

    @Override
    public void close() {
        SubmissionManager submissionManager;
        if (debugEnabled) {
            log.debug("closing JPPF client");
        }
        this.closed.set(true);
        if (debugEnabled) {
            log.debug("closing submission manager");
        }
        if ((submissionManager = this.getSubmissionManager()) != null) {
            submissionManager.close();
        }
        if (debugEnabled) {
            log.debug("closing broadcast receiver");
        }
        if (this.receiverThread != null) {
            this.receiverThread.close();
        }
        if (debugEnabled) {
            log.debug("closing executor");
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        super.close();
    }

    public boolean isLocalExecutionEnabled() {
        SubmissionManager submissionManager = this.getSubmissionManager();
        return submissionManager != null && submissionManager.isLocalExecutionEnabled();
    }

    public void setLocalExecutionEnabled(boolean localExecutionEnabled) {
        SubmissionManager submissionManager = this.getSubmissionManager();
        if (submissionManager != null) {
            submissionManager.setLocalExecutionEnabled(localExecutionEnabled);
        }
    }

    public boolean hasAvailableConnection() {
        SubmissionManager submissionManager = this.getSubmissionManager();
        return submissionManager != null && submissionManager.hasAvailableConnection();
    }

    @Override
    public void statusChanged(ClientConnectionStatusEvent event) {
        super.statusChanged(event);
        SubmissionManager submissionManager = this.getSubmissionManager();
        if (submissionManager != null) {
            ClientConnectionStatusListener listener = submissionManager.getClientConnectionStatusListener();
            if (listener != null) {
                listener.statusChanged(event);
            }
            if (submissionManager instanceof ThreadSynchronization) {
                ((ThreadSynchronization)submissionManager).wakeUp();
            }
        }
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestClassLoader(String uuid, ClassLoader cl) {
        Map<String, ClassLoader> map = this.classLoaderMap;
        synchronized (map) {
            this.classLoaderMap.put(uuid, cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestClassLoader(String uuid) {
        Map<String, ClassLoader> map = this.classLoaderMap;
        synchronized (map) {
            this.classLoaderMap.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getRequestClassLoader(String uuid) {
        Map<String, ClassLoader> map = this.classLoaderMap;
        synchronized (map) {
            return this.classLoaderMap.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionManager getSubmissionManager() {
        AbstractGenericClient abstractGenericClient = this;
        synchronized (abstractGenericClient) {
            if (this.submissionManager == null) {
                this.submissionManager = this.createSubmissionManager();
            }
        }
        return this.submissionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSubmissionManager(SubmissionManager submissionManager) {
        AbstractGenericClient abstractGenericClient = this;
        synchronized (abstractGenericClient) {
            this.submissionManager = submissionManager;
        }
    }

    protected abstract SubmissionManager createSubmissionManager();

    public boolean cancelJob(String jobId) throws Exception {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobUUID is blank");
        }
        boolean cancelled = false;
        for (JPPFClientConnection connection : this.getAllConnections()) {
            if (!(connection instanceof AbstractJPPFClientConnection)) continue;
            cancelled |= ((AbstractJPPFClientConnection)connection).cancelJob(jobId);
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClassLoader registerClassLoader(ClassLoader cl, String uuid) {
        RegisteredClassLoader registeredClassLoader;
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("uuid is null");
        }
        Map<String, Set<RegisteredClassLoader>> map = this.classLoaderRegistrations;
        synchronized (map) {
            registeredClassLoader = new RegisteredClassLoader(uuid, cl);
            Set<RegisteredClassLoader> list = this.classLoaderRegistrations.get(uuid);
            if (list == null) {
                list = new HashSet<RegisteredClassLoader>();
                this.classLoaderRegistrations.put(uuid, list);
                this.addRequestClassLoader(uuid, cl);
            }
            list.add(registeredClassLoader);
        }
        return registeredClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(RegisteredClassLoader registeredClassLoader) {
        if (registeredClassLoader == null) {
            throw new IllegalArgumentException("registeredClassLoader is null");
        }
        Map<String, Set<RegisteredClassLoader>> map = this.classLoaderRegistrations;
        synchronized (map) {
            Set<RegisteredClassLoader> list = this.classLoaderRegistrations.get(registeredClassLoader.getUuid());
            if (list == null) {
                throw new IllegalStateException("ClassLoader already unregistered");
            }
            if (list.remove(registeredClassLoader)) {
                if (list.isEmpty()) {
                    this.classLoaderRegistrations.remove(registeredClassLoader.getUuid());
                    this.removeRequestClassLoader(registeredClassLoader.getUuid());
                }
            } else {
                throw new IllegalStateException("ClassLoader already unregistered");
            }
        }
    }

    public class RegisteredClassLoader {
        private final String uuid;
        private final ClassLoader classLoader;

        protected RegisteredClassLoader(String uuid, ClassLoader classLoader) {
            this.uuid = uuid;
            this.classLoader = classLoader;
        }

        public String getUuid() {
            return this.uuid;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void dispose() {
            AbstractGenericClient.this.unregister(this);
        }
    }
}

