/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jppf.client.ClientConnectionHandler;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientConnectionHandler
implements ClientConnectionHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractClientConnectionHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected SocketWrapper socketClient = null;
    protected SocketInitializer socketInitializer = this.createSocketInitializer();
    private long maxSocketIdleMillis;
    protected String host = null;
    protected int port = -1;
    protected JPPFClientConnection owner = null;
    protected String name = null;
    protected final AtomicReference<JPPFClientConnectionStatus> status = new AtomicReference<JPPFClientConnectionStatus>(JPPFClientConnectionStatus.NEW);
    protected final List<ClientConnectionStatusListener> listeners = new ArrayList<ClientConnectionStatusListener>();

    protected AbstractClientConnectionHandler(JPPFClientConnection owner, String name) {
        this.owner = owner;
        this.name = name;
        long configSocketIdle = JPPFConfiguration.getProperties().getLong("jppf.socket.max-idle", -1L);
        this.maxSocketIdleMillis = configSocketIdle > 10L ? configSocketIdle * 1000L : -1L;
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void setStatus(JPPFClientConnectionStatus newStatus) {
        JPPFClientConnectionStatus oldStatus = this.status.getAndSet(newStatus);
        if (debugEnabled) {
            log.debug("connection '" + this.name + "' status changing from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)newStatus));
        }
        if (newStatus != oldStatus) {
            this.fireStatusChanged(oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected abstract SocketInitializer createSocketInitializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChanged(JPPFClientConnectionStatus oldStatus) {
        ClientConnectionStatusListener[] array;
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new ClientConnectionStatusListener[this.listeners.size()]);
        }
        for (ClientConnectionStatusListener listener : array) {
            listener.statusChanged(event);
        }
    }

    @Override
    public SocketWrapper getSocketClient() throws Exception {
        if (this.maxSocketIdleMillis > 10000L && System.currentTimeMillis() - this.maxSocketIdleMillis > this.socketClient.getSocketTimestamp()) {
            this.close();
            this.init();
        }
        return this.socketClient;
    }

    protected void createSSLConnection() throws Exception {
        this.socketClient = SSLHelper.createSSLClientConnection((SocketWrapper)this.socketClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing " + this.name);
        }
        List<ClientConnectionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
        try {
            if (this.socketInitializer != null) {
                this.socketInitializer.close();
            }
            if (this.socketClient != null) {
                this.socketClient.close();
            }
        }
        catch (Exception e) {
            log.error('[' + this.name + "] " + e.getMessage(), (Throwable)e);
        }
    }
}

