/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceProvider;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.comm.socket.SocketClient;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.data.transform.JPPFDataTransformFactory;
import org.jppf.utils.JPPFBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassServerDelegate
extends AbstractClientConnectionHandler
implements ClassServerDelegate,
Thread.UncaughtExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractClassServerDelegate.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected boolean stop = false;
    protected boolean closed = false;
    protected ResourceProvider resourceProvider = new ResourceProvider();
    protected String clientUuid = null;
    private final Map<String, ClassLoader> classLoaderMap = new Hashtable<String, ClassLoader>();
    protected boolean handshakeDone = false;

    protected AbstractClassServerDelegate(JPPFClientConnection owner) {
        super(owner, owner.getName() + " - ClassServer");
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }

    protected JPPFResourceWrapper readResource() throws Exception {
        JPPFBuffer buffer = this.socketClient.receiveBytes(0);
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        byte[] data = transform == null ? buffer.getBuffer() : JPPFDataTransformFactory.transform((JPPFDataTransform)transform, (boolean)false, (byte[])buffer.buffer, (int)0, (int)buffer.length);
        return (JPPFResourceWrapper)this.socketClient.getSerializer().deserialize(data);
    }

    protected void writeResource(JPPFResourceWrapper resource) throws Exception {
        byte[] data;
        JPPFBuffer buffer = this.socketClient.getSerializer().serialize((Object)resource);
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        byte[] byArray = data = transform == null ? buffer.getBuffer() : JPPFDataTransformFactory.transform((JPPFDataTransform)transform, (boolean)true, (byte[])buffer.buffer, (int)0, (int)buffer.length);
        if (debugEnabled) {
            log.debug("sending " + data.length + " bytes to the server");
        }
        this.socketClient.sendBytes(new JPPFBuffer(data, data.length));
        this.socketClient.flush();
        if (debugEnabled) {
            log.debug("data sent to the server");
        }
    }

    protected void handshake() throws Exception {
        if (debugEnabled) {
            log.debug('[' + this.getName() + "] : sending channel identifier");
        }
        this.socketClient.writeInt(65531);
        if (debugEnabled) {
            log.debug('[' + this.getName() + "] : sending initial resource");
        }
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.PROVIDER_INITIATION);
        resource.addUuid(this.clientUuid);
        resource.setData("connection.uuid", (Object)((AbstractJPPFClientConnection)this.owner).getConnectionUuid());
        this.writeResource(resource);
        this.readResource();
        this.handshakeDone = true;
        if (debugEnabled) {
            log.debug('[' + this.getName() + "] : server handshake done");
        }
    }

    protected void processNextRequest() throws Exception {
        boolean found = true;
        JPPFResourceWrapper resource = this.readResource();
        String name = resource.getName();
        if (debugEnabled) {
            log.debug('[' + this.getName() + "] resource requested: " + resource);
        }
        ClassLoader cl = this.getClassLoader(resource.getRequestUuid());
        if (debugEnabled) {
            log.debug('[' + this.getName() + "] using classloader=" + cl);
        }
        if (resource.getData("multiple") != null) {
            List list = this.resourceProvider.getMultipleResourcesAsBytes(name, cl);
            if (list != null) {
                resource.setData("resource_list", (Object)list);
            }
        } else if (resource.getData("multiple.resources.names") != null) {
            String[] names = (String[])resource.getData("multiple.resources.names");
            Map result = this.resourceProvider.getMultipleResourcesAsBytes(cl, names);
            resource.setData("resource_map", (Object)result);
        } else {
            byte[] callable = resource.getCallable();
            byte[] b = callable != null ? this.resourceProvider.computeCallable(callable) : (resource.isAsResource() ? this.resourceProvider.getResource(name, cl) : this.resourceProvider.getResourceAsBytes(name, cl));
            if (b == null) {
                found = false;
            }
            if (callable == null) {
                resource.setDefinition(b);
            } else {
                resource.setCallable(b);
            }
            if (debugEnabled) {
                if (found) {
                    log.debug('[' + this.getName() + "] found resource: " + name + " (" + b.length + " bytes)");
                } else {
                    log.debug('[' + this.getName() + "] resource not found: " + name);
                }
            }
        }
        resource.setState(JPPFResourceWrapper.State.PROVIDER_RESPONSE);
        this.writeResource(resource);
    }

    protected ClassLoader getClassLoader(String uuid) {
        return ((AbstractJPPFClientConnection)this.owner).getClient().getRequestClassLoader(uuid);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (debugEnabled) {
                log.debug("closing " + this.getName());
            }
            this.closed = true;
            this.stop = true;
            super.close();
            if (debugEnabled) {
                log.debug(this.getName() + " closed");
            }
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error("uncaught exception", e);
    }
}

