/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientSerializer;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.core.Transaction;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ClientThreadContext {
    private static final ConcurrentMap<Thread, ClientThreadContext> mapContexts = new ConcurrentHashMap<Thread, ClientThreadContext>(100);
    TransactionClientProxy transactionProxy;
    final ClientSerializer serializer = new ClientSerializer();
    final Thread thread;

    public ClientThreadContext(Thread thread) {
        this.thread = thread;
    }

    public static ClientThreadContext get() {
        Thread currentThread = Thread.currentThread();
        ClientThreadContext threadContext = (ClientThreadContext)mapContexts.get(currentThread);
        if (threadContext == null) {
            threadContext = new ClientThreadContext(currentThread);
            mapContexts.put(currentThread, threadContext);
            Iterator threads = mapContexts.keySet().iterator();
            while (threads.hasNext()) {
                Thread thread = (Thread)threads.next();
                if (thread.isAlive()) continue;
                threads.remove();
            }
        }
        return threadContext;
    }

    public static void shutdown() {
        mapContexts.clear();
    }

    public Transaction getTransaction(HazelcastClient client) {
        if (this.transactionProxy == null) {
            this.transactionProxy = new TransactionClientProxy(null, client);
        }
        return this.transactionProxy;
    }

    public void removeTransaction() {
        this.transactionProxy = null;
    }

    public byte[] toByte(Object object) {
        return this.serializer.toByteArray(object);
    }

    public Object toObject(byte[] bytes) {
        return this.serializer.toObject(bytes);
    }
}

