/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.rmi;

import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.pepstock.jem.util.UtilMessage;
import org.pepstock.jem.util.rmi.RmiObject;

public class RegistryLocator {
    private Registry registry = null;

    public RegistryLocator(int port) throws RemoteException, UnknownHostException {
        if (this.registry == null) {
            this.registry = LocateRegistry.getRegistry(port);
            this.registry.list();
        }
    }

    public boolean hasRmiObject(String name) throws RemoteException {
        return this.getRmiObject(name) != null;
    }

    public RmiObject getRmiObject(String name) throws RemoteException {
        try {
            return (RmiObject)this.registry.lookup(name);
        }
        catch (NotBoundException nbe) {
            throw new RemoteException(UtilMessage.JEMB003E.toMessage().getFormattedMessage(nbe.getMessage()));
        }
        catch (AccessException ae) {
            throw new RemoteException(UtilMessage.JEMB003E.toMessage().getFormattedMessage(ae.getMessage()));
        }
        catch (RemoteException re) {
            throw re;
        }
    }

    public Object[] getAllRmiObjects() throws RemoteException {
        try {
            return this.registry.list();
        }
        catch (AccessException ae) {
            throw new RemoteException(UtilMessage.JEMB003E.toMessage().getFormattedMessage(ae.getMessage()));
        }
        catch (RemoteException re) {
            throw re;
        }
    }
}

