/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.util.UtilMessage;
import org.pepstock.jem.util.rmi.RmiObject;

public class RegistryContainer {
    private static RegistryContainer CONTAINER = null;
    private Registry registry = null;
    private int port = 1099;

    private RegistryContainer(int port) throws RemoteException {
        this.registry = LocateRegistry.createRegistry(port, null, new RMISocketFactory(){

            @Override
            public ServerSocket createServerSocket(int arg0) throws IOException {
                return new ServerSocket(arg0){

                    @Override
                    public Socket accept() throws IOException {
                        String localhost;
                        Socket socket = super.accept();
                        String resolved = socket.getInetAddress().getHostAddress();
                        if (!resolved.equalsIgnoreCase(localhost = InetAddress.getLocalHost().getHostAddress())) {
                            socket.shutdownInput();
                            socket.shutdownOutput();
                            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB007E, resolved);
                        }
                        return socket;
                    }
                };
            }

            @Override
            public Socket createSocket(String arg0, int arg1) throws IOException {
                return new Socket(arg0, arg1);
            }
        });
        this.port = port;
    }

    public static RegistryContainer getInstance() {
        if (CONTAINER != null) {
            return CONTAINER;
        }
        throw new RuntimeException(UtilMessage.JEMB001E.toMessage().getMessage());
    }

    public static synchronized RegistryContainer createInstance(int port) throws RemoteException {
        if (CONTAINER == null) {
            CONTAINER = new RegistryContainer(port);
        }
        return CONTAINER;
    }

    public int getPort() {
        return this.port;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void addRmiObject(String name, RmiObject obj) throws RemoteException {
        try {
            this.registry.unbind(name);
        }
        catch (NotBoundException nbe) {
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB006I, name);
        }
        catch (AccessException ae) {
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB006I, name);
        }
        catch (RemoteException re) {
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB006I, name);
        }
        try {
            this.registry.bind(name, obj);
        }
        catch (AlreadyBoundException abe) {
            throw new RemoteException(UtilMessage.JEMB003E.toMessage().getFormattedMessage(abe.getMessage()));
        }
        catch (AccessException ae) {
            throw new RemoteException(UtilMessage.JEMB003E.toMessage().getFormattedMessage(ae.getMessage()));
        }
        catch (RemoteException re) {
            throw re;
        }
    }
}

