/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.locks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.InstanceDestroyedException;
import org.pepstock.jem.util.locks.ConcurrentLock;

public class ReadLock
extends ConcurrentLock {
    private static final String MAP_KEY = "readers";
    private IMap<String, Long> readers = null;

    public ReadLock(HazelcastInstance instance, String queueName) {
        super(instance, queueName);
        this.readers = instance.getMap("countersMutex." + queueName);
    }

    @Override
    public void acquire() throws Exception {
        try {
            this.getNoWaiting().acquire();
        }
        catch (InstanceDestroyedException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        Long n_readers = null;
        Long prev = null;
        try {
            this.readers.lock((Object)MAP_KEY);
            prev = (Long)this.readers.get((Object)MAP_KEY);
            if (prev == null) {
                prev = 0L;
            }
            n_readers = prev + 1L;
            this.readers.put((Object)MAP_KEY, (Object)n_readers);
        }
        catch (Exception e) {
            this.getNoWaiting().release();
            throw e;
        }
        finally {
            this.readers.unlock((Object)MAP_KEY);
        }
        if (prev == 0L) {
            try {
                this.getNoAccessing().acquire();
            }
            catch (InstanceDestroyedException e) {
                this.getNoWaiting().release();
                throw e;
            }
            catch (InterruptedException e) {
                this.getNoWaiting().release();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws Exception {
        Long n_readers = null;
        Long prev = null;
        try {
            this.readers.lock((Object)MAP_KEY);
            prev = (Long)this.readers.get((Object)MAP_KEY);
            n_readers = prev - 1L;
            this.readers.put((Object)MAP_KEY, (Object)n_readers);
        }
        finally {
            this.readers.unlock((Object)MAP_KEY);
        }
        if (n_readers == 0L) {
            this.getNoAccessing().release();
        }
    }
}

