/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters.predicates;

import com.hazelcast.core.MapEntry;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.TimeUtils;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.ParseException;
import org.pepstock.jem.util.filters.fields.RoleFilterFields;
import org.pepstock.jem.util.filters.predicates.JemFilterPredicate;

public class RolePredicate
extends JemFilterPredicate<Role>
implements Serializable {
    private static final long serialVersionUID = -1410063063130458355L;

    public RolePredicate() {
    }

    public RolePredicate(Filter filter) {
        super(filter);
    }

    @Override
    public boolean apply(MapEntry entry) {
        Role role = (Role)entry.getValue();
        boolean includeThis = true;
        FilterToken[] tokens = this.getFilter().toTokenArray();
        long now = System.currentTimeMillis();
        block10: for (int i = 0; i < tokens.length && includeThis; ++i) {
            FilterToken token = tokens[i];
            String tokenName = token.getName();
            String tokenValue = token.getValue();
            RoleFilterFields field = RoleFilterFields.getByName(tokenName);
            if (field == null) {
                field = RoleFilterFields.NAME;
            }
            switch (field) {
                case NAME: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)role.getName(), (CharSequence)tokenValue);
                    continue block10;
                }
                case REMOVABLE: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)String.valueOf(role.isRemovable()), (CharSequence)tokenValue);
                    continue block10;
                }
                case PERMISSIONS: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)role.getPermissions().toString(), (CharSequence)tokenValue);
                    continue block10;
                }
                case USERS: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)role.getUsers().toString(), (CharSequence)tokenValue);
                    continue block10;
                }
                case MODIFIED: {
                    try {
                        long inputTime = TimeUtils.parseDuration(tokenValue);
                        long roleModifiedTime = now - role.getLastModified().getTime();
                        includeThis &= roleModifiedTime >= inputTime;
                    }
                    catch (ParseException e) {
                        includeThis &= false;
                    }
                    continue block10;
                }
                case MODIFIED_BY: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)role.getUser(), (CharSequence)tokenValue);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unrecognized Role filter field: " + field);
                }
            }
        }
        return includeThis;
    }
}

