/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters.predicates;

import com.hazelcast.core.MapEntry;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.util.TimeUtils;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.ParseException;
import org.pepstock.jem.util.filters.fields.ResourceFilterFields;
import org.pepstock.jem.util.filters.predicates.JemFilterPredicate;

public class ResourcePredicate
extends JemFilterPredicate<Resource>
implements Serializable {
    private static final long serialVersionUID = 8087227037699399624L;

    public ResourcePredicate() {
    }

    public ResourcePredicate(Filter filter) {
        super(filter);
    }

    @Override
    public boolean apply(MapEntry entry) {
        Resource resource = (Resource)entry.getValue();
        boolean includeThis = true;
        FilterToken[] tokens = this.getFilter().toTokenArray();
        long now = System.currentTimeMillis();
        block9: for (int i = 0; i < tokens.length && includeThis; ++i) {
            FilterToken token = tokens[i];
            String tokenName = token.getName();
            String tokenValue = token.getValue();
            ResourceFilterFields field = ResourceFilterFields.getByName(tokenName);
            if (field == null) {
                field = ResourceFilterFields.NAME;
            }
            switch (field) {
                case NAME: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)resource.getName(), (CharSequence)tokenValue);
                    continue block9;
                }
                case TYPE: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)resource.getType(), (CharSequence)tokenValue);
                    continue block9;
                }
                case PROPERTIES: {
                    int count = 0;
                    String value = null;
                    for (ResourceProperty property : resource.getProperties().values()) {
                        value = count == 0 ? property.getName() + " = " + (property.isVisible() ? property.getValue() : "***") : value + ", " + property.getName() + " = " + (property.isVisible() ? property.getValue() : "***");
                        ++count;
                    }
                    includeThis &= StringUtils.containsIgnoreCase(value, (CharSequence)tokenValue);
                    continue block9;
                }
                case MODIFIED: {
                    try {
                        long inputTime = TimeUtils.parseDuration(tokenValue);
                        long resourceModifiedTime = now - resource.getLastModified().getTime();
                        includeThis &= resourceModifiedTime >= inputTime;
                    }
                    catch (ParseException e) {
                        includeThis &= false;
                    }
                    continue block9;
                }
                case MODIFIED_BY: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)resource.getUser(), (CharSequence)tokenValue);
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Unrecognized Resource filter field: " + field);
                }
            }
        }
        return includeThis;
    }
}

