/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters.predicates;

import com.hazelcast.core.MapEntry;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;
import org.pepstock.jem.util.filters.predicates.JemFilterPredicate;

public class NodePredicate
extends JemFilterPredicate<NodeInfoBean>
implements Serializable {
    private static final long serialVersionUID = -904322802073196095L;

    public NodePredicate() {
    }

    public NodePredicate(Filter filter) {
        super(filter);
    }

    @Override
    public boolean apply(MapEntry entry) {
        NodeInfoBean node = ((NodeInfo)entry.getValue()).getNodeInfoBean();
        if (node.isSuperNode()) {
            return false;
        }
        boolean includeThis = true;
        FilterToken[] tokens = this.getFilter().toTokenArray();
        block11: for (int i = 0; i < tokens.length && includeThis; ++i) {
            FilterToken token = tokens[i];
            String tokenName = token.getName();
            String tokenValue = token.getValue();
            NodeFilterFields field = NodeFilterFields.getByName(tokenName);
            if (field == null) {
                field = NodeFilterFields.NAME;
            }
            switch (field) {
                case NAME: {
                    if (tokenValue.equalsIgnoreCase("*")) {
                        includeThis &= true;
                        continue block11;
                    }
                    if (tokenValue.endsWith("*")) {
                        tokenValue = StringUtils.substringBeforeLast((String)tokenValue, (String)"*");
                    }
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getLabel(), (CharSequence)tokenValue);
                    continue block11;
                }
                case HOSTNAME: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getHostname(), (CharSequence)tokenValue);
                    continue block11;
                }
                case DOMAIN: {
                    includeThis &= node.isSuperNode() ? StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)tokenValue) : StringUtils.containsIgnoreCase((CharSequence)node.getExecutionEnvironment().getDomain(), (CharSequence)tokenValue);
                    continue block11;
                }
                case STATIC_AFFINITIES: {
                    includeThis &= node.isSuperNode() ? StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)tokenValue) : StringUtils.containsIgnoreCase((CharSequence)node.getExecutionEnvironment().getStaticAffinities().toString(), (CharSequence)tokenValue);
                    continue block11;
                }
                case DYNAMIC_AFFINITIES: {
                    includeThis &= node.isSuperNode() ? StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)tokenValue) : StringUtils.containsIgnoreCase((CharSequence)node.getExecutionEnvironment().getDynamicAffinities().toString(), (CharSequence)tokenValue);
                    continue block11;
                }
                case STATUS: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getStatus(), (CharSequence)tokenValue);
                    continue block11;
                }
                case OS: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getSystemName(), (CharSequence)tokenValue);
                    continue block11;
                }
                case CURRENT_JOB: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getJobName(), (CharSequence)tokenValue);
                    continue block11;
                }
                case ENVIRONMENT: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)node.getExecutionEnvironment().getEnvironment(), (CharSequence)tokenValue);
                    continue block11;
                }
                default: {
                    throw new RuntimeException("Unrecognized Node filter field: " + field);
                }
            }
        }
        return includeThis;
    }
}

