/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters.predicates;

import com.hazelcast.core.MapEntry;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.util.TimeUtils;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.JobFilterFields;
import org.pepstock.jem.util.filters.predicates.JemFilterPredicate;

public class JobPredicate
extends JemFilterPredicate<Job>
implements Serializable {
    private static final long serialVersionUID = 7910310173201523940L;

    public JobPredicate() {
    }

    public JobPredicate(Filter filter) {
        super(filter);
    }

    @Override
    public boolean apply(MapEntry entry) {
        Job job = (Job)entry.getValue();
        boolean includeThis = true;
        FilterToken[] tokens = this.getFilter().toTokenArray();
        long now = System.currentTimeMillis();
        block24: for (int i = 0; i < tokens.length && includeThis; ++i) {
            FilterToken token = tokens[i];
            String tokenName = token.getName();
            String tokenValue = token.getValue();
            JobFilterFields field = JobFilterFields.getByName(tokenName);
            if (field == null) {
                field = JobFilterFields.NAME;
            }
            switch (field) {
                case NAME: {
                    if (tokenValue.equalsIgnoreCase("*")) {
                        includeThis &= true;
                        continue block24;
                    }
                    if (tokenValue.endsWith("*")) {
                        tokenValue = StringUtils.substringBeforeLast((String)tokenValue, (String)"*");
                    }
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getName(), (CharSequence)tokenValue);
                    continue block24;
                }
                case TYPE: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getJcl().getType(), (CharSequence)tokenValue);
                    continue block24;
                }
                case USER: {
                    includeThis &= job.isUserSurrogated() ? StringUtils.containsIgnoreCase((CharSequence)job.getJcl().getUser(), (CharSequence)tokenValue) : StringUtils.containsIgnoreCase((CharSequence)job.getUser(), (CharSequence)tokenValue);
                    continue block24;
                }
                case ENVIRONMENT: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getJcl().getEnvironment(), (CharSequence)tokenValue);
                    continue block24;
                }
                case DOMAIN: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getJcl().getDomain(), (CharSequence)tokenValue);
                    continue block24;
                }
                case AFFINITY: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getJcl().getAffinity(), (CharSequence)tokenValue);
                    continue block24;
                }
                case SUBMITTED_TIME: {
                    try {
                        long inputTime = TimeUtils.parseDuration(tokenValue);
                        long jobSubmittedTime = now - job.getSubmittedTime().getTime();
                        includeThis &= jobSubmittedTime <= inputTime;
                    }
                    catch (Exception e) {
                        includeThis &= false;
                    }
                    continue block24;
                }
                case PRIORITY: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)String.valueOf(job.getJcl().getPriority()), (CharSequence)tokenValue);
                    continue block24;
                }
                case MEMORY: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)String.valueOf(job.getJcl().getMemory()), (CharSequence)tokenValue);
                    continue block24;
                }
                case STEP: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getCurrentStep().getName(), (CharSequence)tokenValue);
                    continue block24;
                }
                case RUNNING_TIME: {
                    try {
                        long inputTime = TimeUtils.parseDuration(tokenValue);
                        long jobRunningTime = now - job.getStartedTime().getTime();
                        includeThis &= jobRunningTime <= inputTime;
                    }
                    catch (Exception e) {
                        includeThis &= false;
                    }
                    continue block24;
                }
                case MEMBER: {
                    includeThis &= StringUtils.containsIgnoreCase((CharSequence)job.getMemberLabel(), (CharSequence)tokenValue);
                    continue block24;
                }
                case ENDED_TIME: {
                    try {
                        long inputTime = TimeUtils.parseDuration(tokenValue);
                        long jobEndedTime = now - job.getEndedTime().getTime();
                        includeThis &= jobEndedTime <= inputTime;
                    }
                    catch (Exception e) {
                        includeThis &= false;
                    }
                    continue block24;
                }
                case RETURN_CODE: {
                    try {
                        int inputReturnCode = Integer.parseInt(tokenValue);
                        includeThis &= job.getResult().getReturnCode() == inputReturnCode;
                    }
                    catch (Exception e) {
                        includeThis &= false;
                    }
                    continue block24;
                }
                default: {
                    throw new RuntimeException("Unrecognized Job filter field: " + field);
                }
            }
        }
        return includeThis;
    }
}

