/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters;

import java.io.Serializable;
import org.pepstock.jem.util.filters.ParseException;

public class FilterToken
implements Serializable {
    private static final long serialVersionUID = -2475107758060833621L;
    public static final String FILTER_TOKEN_SEPARATOR = ":";
    private String name = null;
    private String value = null;

    public FilterToken() {
    }

    public FilterToken(String filterName, String filterValue) {
        if (filterName != null) {
            this.name = filterName.trim().toLowerCase();
        }
        this.value = filterValue.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() > 0;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null && this.value.length() > 0;
    }

    public boolean hasValueOnly() {
        return !this.hasName() && this.hasValue();
    }

    public boolean is(String filterName) {
        return this.name.equals(filterName.trim().toLowerCase());
    }

    public String toString() {
        return this.name + FILTER_TOKEN_SEPARATOR + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterToken other = (FilterToken)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static FilterToken parse(String tokenString) throws ParseException {
        try {
            if (tokenString == null || tokenString.trim().isEmpty()) {
                throw new ParseException("Unparsable null/empty tokenString");
            }
            String[] nameValue = tokenString.split(FILTER_TOKEN_SEPARATOR);
            switch (nameValue.length) {
                case 2: {
                    return new FilterToken(nameValue[0], nameValue[1]);
                }
                case 1: {
                    return new FilterToken(null, nameValue[0]);
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        catch (Exception e) {
            throw new ParseException("Unparsable tokenString '" + tokenString + "; cause: " + e.getMessage());
        }
    }
}

