/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.ParseException;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -838170972345576173L;
    public static final String SPACE = " ";
    public static final String DOUBLE_SPACE = "  ";
    protected HashMap<String, String> elements = new HashMap();

    public void add(FilterToken token) {
        if (token.hasValueOnly() && this.has(null)) {
            token.setValue(this.get(null).trim() + SPACE + token.getValue());
        }
        if (token.hasValue()) {
            this.elements.put(token.getName(), token.getValue());
        }
    }

    public boolean has(String filterName) {
        return this.get(filterName) != null;
    }

    public String get(String filterName) {
        return this.elements.get(filterName);
    }

    public void remove(FilterToken token) {
        this.remove(token.getName());
    }

    public void remove(String filterName) {
        this.elements.remove(filterName);
    }

    public int count() {
        return this.elements.size();
    }

    public void clear() {
        this.elements.clear();
    }

    public Set<String> names() {
        return new HashSet<String>(this.elements.keySet());
    }

    public Collection<String> values() {
        return new ArrayList<String>(this.elements.values());
    }

    public FilterToken[] toTokenArray() {
        FilterToken[] array = new FilterToken[this.names().size()];
        int i = 0;
        for (String name : this.names()) {
            array[i] = new FilterToken(name, this.get(name));
            ++i;
        }
        return array;
    }

    public String toSearchString() {
        StringBuilder sb = new StringBuilder();
        for (String currentName : this.elements.keySet()) {
            String currentValue = this.elements.get(currentName);
            if (currentName != null) {
                sb.append(currentName).append(":");
            }
            sb.append(currentValue);
            sb.append(SPACE);
        }
        return sb.toString().trim();
    }

    public String toString() {
        return "Filter [elements=" + this.elements + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public static Filter parse(String searchString) throws ParseException {
        try {
            String[] tokens;
            if (searchString == null || searchString.trim().isEmpty()) {
                throw new ParseException("Unparsable null/empty searchString");
            }
            Filter toReturn = new Filter();
            for (String tokenString : tokens = searchString.trim().split(SPACE)) {
                try {
                    FilterToken token = FilterToken.parse(tokenString);
                    toReturn.add(token);
                }
                catch (ParseException tpe) {
                    // empty catch block
                }
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new ParseException("Unparsable searchString '" + searchString + "'; cause: " + e.getMessage());
        }
    }
}

