/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(File folder, OutputStream zipOutputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        ZipArchiveOutputStream zipArchiveOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
            zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)bufferedOutputStream);
            ZipUtil.addFileToZip(zipArchiveOutputStream, folder);
        }
        finally {
            if (zipArchiveOutputStream != null) {
                zipArchiveOutputStream.finish();
                zipArchiveOutputStream.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static void addFileToZip(ZipArchiveOutputStream zipArchiveOutputStream, File file) throws IOException {
        ZipUtil.addFileToZip(zipArchiveOutputStream, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(ZipArchiveOutputStream zipArchiveOutputStream, File file, String path) throws IOException {
        block5: {
            String entryName;
            block4: {
                entryName = path != null ? path + file.getName() : file.getName();
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(file, entryName);
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                if (!file.isFile()) break block4;
                FileInputStream fInputStream = null;
                try {
                    fInputStream = new FileInputStream(file);
                    IOUtils.copy((InputStream)fInputStream, (OutputStream)zipArchiveOutputStream);
                    zipArchiveOutputStream.closeArchiveEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fInputStream);
                break block5;
            }
            zipArchiveOutputStream.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    ZipUtil.addFileToZip(zipArchiveOutputStream, child, entryName + "/");
                }
            }
        }
    }
}

