/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import org.pepstock.jem.Job;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.util.UtilMessage;
import org.pepstock.jem.util.VariablesFactoryException;

public class VariablesFactory {
    public static final String JEM_VARIABLES_SEPARATOR = ".";
    public static final String JEM_VARIABLE_PREFIX = "jem.";
    public static final String JOB_VARIABLE_PREFIX = "jem.job.";
    public static final String NODE_INFO_VARIABLE_PREFIX = "jem.nodeInfo.";
    public static final String VARIABLE_NO_VALUE = "N/A (null)";

    public static Properties createVariables(Job job, NodeInfoBean nodeInfo) throws VariablesFactoryException {
        Properties properties = new Properties();
        Properties jobVariables = VariablesFactory.createVariables(job);
        Properties nodeInfoVariables = VariablesFactory.createVariables(nodeInfo);
        properties.putAll((Map<?, ?>)jobVariables);
        properties.putAll((Map<?, ?>)nodeInfoVariables);
        return properties;
    }

    public static Properties createVariables(Job job) throws VariablesFactoryException {
        try {
            Properties properties = new Properties();
            Field[] declaredFields = Job.class.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                boolean isAccessible = field.isAccessible();
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                VariablesFactory.addObjectFieldVariable(field, job, JOB_VARIABLE_PREFIX, properties);
                Object fieldValue = field.get(job);
                VariablesFactory.addObjectFieldVariables(fieldValue, field.getType(), JOB_VARIABLE_PREFIX + field.getName() + JEM_VARIABLES_SEPARATOR, properties);
                if (isAccessible) continue;
                field.setAccessible(false);
            }
            return properties;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB004E, ex, job);
            throw new VariablesFactoryException(UtilMessage.JEMB004E.toMessage().getFormattedMessage(job));
        }
    }

    public static Properties createVariables(NodeInfoBean nodeInfo) throws VariablesFactoryException {
        try {
            Properties properties = new Properties();
            Field[] declaredFields = NodeInfoBean.class.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                boolean isAccessible = field.isAccessible();
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                VariablesFactory.addObjectFieldVariable(field, nodeInfo, NODE_INFO_VARIABLE_PREFIX, properties);
                Object fieldValue = field.get(nodeInfo);
                VariablesFactory.addObjectFieldVariables(fieldValue, field.getType(), NODE_INFO_VARIABLE_PREFIX + field.getName() + JEM_VARIABLES_SEPARATOR, properties);
                if (isAccessible) continue;
                field.setAccessible(false);
            }
            return properties;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB004E, ex, nodeInfo);
            throw new VariablesFactoryException(UtilMessage.JEMB004E.toMessage().getFormattedMessage(nodeInfo));
        }
    }

    private static void addObjectFieldVariables(Object fieldObject, Class fieldClass, String variablePrefix, Properties properties) throws Exception {
        if (!fieldClass.isPrimitive() && fieldClass.getClassLoader() != String.class.getClassLoader()) {
            Field[] declaredFields = fieldClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                boolean isAccessible = field.isAccessible();
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                VariablesFactory.addObjectFieldVariable(field, fieldObject, variablePrefix, properties);
                Object fieldValue = null;
                if (null != fieldObject) {
                    fieldValue = field.get(fieldObject);
                }
                VariablesFactory.addObjectFieldVariables(fieldValue, field.getType(), variablePrefix + field.getName() + JEM_VARIABLES_SEPARATOR, properties);
                if (isAccessible) continue;
                field.setAccessible(false);
            }
        }
    }

    private static void addObjectFieldVariable(Field field, Object fieldOwner, String variablePrefix, Properties properties) throws Exception {
        String fieldName = field.getName();
        Object fieldValue = null;
        if (null != fieldOwner) {
            fieldValue = field.get(fieldOwner);
        }
        if (null != fieldValue) {
            properties.put(variablePrefix + fieldName, fieldValue.toString());
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB005I, variablePrefix + fieldName, fieldValue);
        } else {
            properties.put(variablePrefix + fieldName, VARIABLE_NO_VALUE);
            LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB005I, variablePrefix + fieldName, VARIABLE_NO_VALUE);
        }
    }
}

