/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.util.filters.ParseException;

public class TimeUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final String D_STRING = "d";
    public static final String H_STRING = "h";
    public static final String M_STRING = "m";
    public static final char D = 'd';
    public static final char H = 'h';
    public static final char M = 'm';

    private TimeUtils() {
    }

    public static long parseDuration(String tokenValue) throws ParseException {
        long time;
        int timeValue;
        if (!(StringUtils.endsWithIgnoreCase((CharSequence)tokenValue, (CharSequence)D_STRING) || StringUtils.endsWithIgnoreCase((CharSequence)tokenValue, (CharSequence)H_STRING) || StringUtils.endsWithIgnoreCase((CharSequence)tokenValue, (CharSequence)M_STRING))) {
            throw new ParseException("Invalid time unit!");
        }
        int timeUnitIndex = tokenValue.length() - 1;
        char timeUnit = tokenValue.charAt(timeUnitIndex);
        try {
            timeValue = Integer.parseInt(tokenValue.substring(0, timeUnitIndex));
        }
        catch (Exception e) {
            throw new ParseException("Invalid time value!");
        }
        switch (timeUnit) {
            case 'd': {
                time = (long)timeValue * 86400000L;
                break;
            }
            case 'h': {
                time = (long)timeValue * 3600000L;
                break;
            }
            case 'm': {
                time = (long)timeValue * 60000L;
                break;
            }
            default: {
                throw new ParseException("Invalid time unit!");
            }
        }
        return time;
    }
}

