/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.util.UtilMessage;

public class RestClient {
    private static RestClient CLIENT = null;
    private ApacheHttpClient4 client = null;
    private URI baseURI = null;

    private RestClient(String uriString) {
        this.baseURI = UriBuilder.fromUri((String)uriString).build(new Object[0]);
        DefaultClientConfig config = new DefaultClientConfig();
        this.client = ApacheHttpClient4.create((ClientConfig)config);
        HttpClient hc = this.client.getClientHandler().getHttpClient();
        if (this.baseURI.getScheme().equalsIgnoreCase("https")) {
            try {
                this.configureSSLHandling(hc, this.baseURI);
            }
            catch (KeyManagementException e) {
                LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB008E, e);
            }
            catch (UnrecoverableKeyException e) {
                LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB008E, e);
            }
            catch (NoSuchAlgorithmException e) {
                LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB008E, e);
            }
            catch (KeyStoreException e) {
                LogAppl.getInstance().emit((MessageInterface)UtilMessage.JEMB008E, e);
            }
        }
    }

    public static RestClient createInstance(String uriString) {
        CLIENT = new RestClient(uriString);
        return CLIENT;
    }

    public static RestClient getInstance() {
        if (CLIENT == null) {
            throw new RuntimeException(UtilMessage.JEMB002E.toMessage().getMessage());
        }
        return CLIENT;
    }

    public WebResource getBaseWebResource() {
        return this.client.resource(this.baseURI);
    }

    private void configureSSLHandling(HttpClient hc, URI uri) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        SSLSocketFactory sf = this.buildSSLSocketFactory();
        Scheme https = new Scheme(uri.getScheme(), uri.getPort(), (SchemeSocketFactory)sf);
        SchemeRegistry sr = hc.getConnectionManager().getSchemeRegistry();
        sr.register(https);
    }

    private SSLSocketFactory buildSSLSocketFactory() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        return new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }
}

