/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

public class Parser {
    public static int parseInt(String s) {
        return Parser.parseInt(s, 0);
    }

    public static int parseInt(String s, int defaultValue) {
        try {
            return s == null ? defaultValue : Integer.parseInt(s.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long parseLong(String s) {
        return Parser.parseLong(s, 0L);
    }

    public static long parseLong(String s, long defaultValue) {
        try {
            return s == null ? defaultValue : Long.parseLong(s.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static double parseDouble(String s) {
        return Parser.parseDouble(s, 0.0);
    }

    public static double parseDouble(String s, double defaultValue) {
        try {
            return s == null ? defaultValue : Double.parseDouble(s.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static float parseFloat(String s) {
        return Parser.parseFloat(s, 0.0f);
    }

    public static float parseFloat(String s, float defaultValue) {
        try {
            return s == null ? defaultValue : Float.parseFloat(s.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String s) {
        return Parser.parseBoolean(s, false);
    }

    public static boolean parseBoolean(String s, boolean defaultValue) {
        return s == null ? defaultValue : Boolean.valueOf(s);
    }
}

