/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.util;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang3.StringUtils;

public class CmdConsole {
    private PrintStream writer = null;
    private BufferedReader reader = null;
    private Console console = System.console();

    public CmdConsole() {
        if (this.console == null) {
            this.reader = new BufferedReader(new InputStreamReader(System.in));
            this.writer = System.out;
        } else {
            this.reader = new BufferedReader(this.console.reader());
            this.writer = new PrintStream((OutputStream)new WriterOutputStream((Writer)this.console.writer()));
        }
    }

    public String readPassword(String userid) throws IOException {
        String prompt = userid + "'s password: ";
        if (this.console == null) {
            this.writer.print(prompt);
            return this.reader.readLine();
        }
        char[] passwordChar = this.console.readPassword(prompt, new Object[0]);
        return new String(passwordChar);
    }

    public String[] readCommand(String prompt) throws IOException {
        String record;
        if (this.console == null) {
            this.writer.print(prompt);
            record = this.reader.readLine();
            if (record == null) {
                record = "";
            }
        } else {
            record = this.console.readLine(prompt, null);
        }
        if (record.trim().length() > 0) {
            return StringUtils.split((String)record, (String)" ");
        }
        return null;
    }

    public void print(StringBuffer record) {
        this.print(record.toString());
    }

    public void print(String record) {
        this.writer.println(record);
        this.writer.flush();
    }

    public PrintStream getWriter() {
        return this.writer;
    }

    public BufferedReader getReader() {
        return this.reader;
    }
}

