/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.utilities;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.naming.InitialContext;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.JemTasklet;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.repeat.RepeatStatus;

public class CopyTasklet
extends JemTasklet {
    private static final int BUF_SIZE = 8192;
    private static final String INPUT_DATA_DESCRIPTION_NAME = "INPUT";
    private static final String OUTPUT_DATA_DESCRIPTION_NAME = "OUTPUT";

    @Override
    public RepeatStatus run(StepContribution stepContribution, ChunkContext chuckContext) throws Exception {
        InitialContext ic = ContextUtils.getContext();
        Object input = ic.lookup(INPUT_DATA_DESCRIPTION_NAME);
        Object output = ic.lookup(OUTPUT_DATA_DESCRIPTION_NAME);
        InputStream istream = null;
        OutputStream ostream = null;
        if (!(input instanceof InputStream)) {
            throw new Exception(SpringBatchMessage.JEMS011E.toMessage().getFormattedMessage(INPUT_DATA_DESCRIPTION_NAME, input.getClass().getName()));
        }
        istream = (InputStream)input;
        if (!(output instanceof OutputStream)) {
            throw new Exception(SpringBatchMessage.JEMS010E.toMessage().getFormattedMessage(OUTPUT_DATA_DESCRIPTION_NAME, output.getClass().getName()));
        }
        ostream = (OutputStream)output;
        if (istream instanceof FileInputStream) {
            FileChannel ichannel = ((FileInputStream)istream).getChannel();
            ichannel.transferTo(0L, ichannel.size(), Channels.newChannel(ostream));
            ichannel.close();
        } else if (ostream instanceof FileOutputStream) {
            FileChannel ochannel = ((FileOutputStream)ostream).getChannel();
            ochannel.transferFrom(Channels.newChannel(istream), 0L, Long.MAX_VALUE);
            ochannel.close();
        } else {
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                ostream.write(buffer, 0, count);
            } while ((count = istream.read(buffer, 0, buffer.length)) != -1);
            ostream.close();
            istream.close();
        }
        return RepeatStatus.FINISHED;
    }
}

