/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.managers;

import java.util.ArrayList;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.gdg.GDGManager;
import org.pepstock.jem.node.ResourceLock;
import org.pepstock.jem.node.rmi.ResourceLocker;
import org.pepstock.jem.node.tasks.InitiatorManager;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.items.DataDescriptionItem;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.pepstock.jem.springbatch.tasks.JemTasklet;
import org.pepstock.jem.springbatch.tasks.Lock;
import org.pepstock.jem.springbatch.tasks.managers.DataDescriptionManager;
import org.pepstock.jem.springbatch.tasks.managers.Definition;
import org.pepstock.jem.springbatch.tasks.managers.DefinitionsContainer;
import org.pepstock.jem.springbatch.tasks.managers.ImplementationsContainer;
import org.springframework.core.io.Resource;

public class Locker {
    private ArrayList<ResourceLock> resources = new ArrayList();
    private ResourceLocker locker = InitiatorManager.getResourceLocker();
    private boolean isExecutionStarted = false;

    public Locker() throws Exception {
        ImplementationsContainer.getInstance();
    }

    public void lock() throws Exception {
        for (Definition object : DefinitionsContainer.getInstance().getObjects()) {
            if (object.isJemTasklet()) {
                this.loadTasklet(object);
                continue;
            }
            this.loadChunk(object);
        }
        if (!this.resources.isEmpty()) {
            this.locker.lock(this.resources);
        }
        for (Definition object : DefinitionsContainer.getInstance().getObjects()) {
            if (!object.isChunkItem()) continue;
            this.loadChunkPostLock(object);
        }
        this.isExecutionStarted = true;
    }

    private void loadTasklet(Definition taskletandstepname) throws Exception {
        JemTasklet tasklet = (JemTasklet)taskletandstepname.getObject();
        String stepName = taskletandstepname.getStepName();
        for (DataDescription dd : tasklet.getDataDescriptionList()) {
            DataDescriptionImpl ddImpl = DataDescriptionManager.createDataDescriptionImpl(dd, stepName);
            InitiatorManager.addResourcesLock(ddImpl, this.resources);
        }
        for (Lock lock : tasklet.getLocks()) {
            if (lock.getName() == null) continue;
            ResourceLock rLock = new ResourceLock(lock.getName(), 1);
            this.resources.add(rLock);
        }
    }

    private void loadChunk(Definition object) throws Exception {
        DataDescriptionItem item = (DataDescriptionItem)object.getObject();
        String stepName = object.getStepName();
        DataDescriptionImpl ddImpl = DataDescriptionManager.createDataDescriptionImpl(item.getDataDescription(), stepName);
        item.setDataDescriptionImpl(ddImpl);
        InitiatorManager.addResourcesLock(ddImpl, this.resources);
    }

    private void loadChunkPostLock(Definition object) throws Exception {
        DataDescriptionItem item = (DataDescriptionItem)object.getObject();
        GDGManager.load(item.getDataDescriptionImpl());
        System.out.println(SpringBatchMessage.JEMS023I.toMessage().getFormattedMessage(item.getDataDescriptionImpl()));
        int size = item.getDataDescription().getDatasets().size();
        DataSet[] datasets = new DataSet[size];
        for (int i = 0; i < size; ++i) {
            datasets[i] = item.getDataDescription().getDatasets().get(i);
        }
        item.setResources((Resource[])datasets);
    }

    private void loadChunkPostUnLock(Definition object) throws Exception {
        DataDescriptionItem item = (DataDescriptionItem)object.getObject();
        if (this.isExecutionStarted) {
            GDGManager.store(item.getDataDescriptionImpl());
        }
    }

    public void unlock() throws Exception {
        for (Definition object : DefinitionsContainer.getInstance().getObjects()) {
            if (!object.isChunkItem()) continue;
            this.loadChunkPostUnLock(object);
        }
        if (!this.resources.isEmpty()) {
            this.locker.unlock();
            this.resources.clear();
            DefinitionsContainer.getInstance().getObjects().clear();
        }
    }
}

