/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.managers;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.pepstock.catalog.DataDescriptionImpl;

public class ImplementationsContainer {
    private static final MessageFormat mf = new MessageFormat("*.{0}.{1}");
    private static final MessageFormat mf4search = new MessageFormat("*.{0}.");
    private static ImplementationsContainer INSTANCE = null;
    private HashMap<String, DataDescriptionImpl> mapDataDescription = new HashMap();

    private ImplementationsContainer() {
    }

    public static synchronized ImplementationsContainer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImplementationsContainer();
        }
        return INSTANCE;
    }

    public boolean hasDataDescription(String reference) {
        return reference != null ? this.mapDataDescription.containsKey(reference.toLowerCase()) : false;
    }

    public DataDescriptionImpl getDataDescription(String reference) {
        return reference != null ? this.mapDataDescription.get(reference.toLowerCase()) : null;
    }

    public List<DataDescriptionImpl> getDataDescriptionsByItem(String step) {
        ArrayList<DataDescriptionImpl> result = new ArrayList<DataDescriptionImpl>();
        String keyPattern = this.createKey(step);
        for (String key : this.mapDataDescription.keySet()) {
            if (!key.startsWith(keyPattern)) continue;
            result.add(this.mapDataDescription.get(key));
        }
        return result;
    }

    public void addDataDescription(String step, DataDescriptionImpl dd) {
        String key = this.createKey(step, dd.getName());
        this.mapDataDescription.put(key, dd);
    }

    private String createKey(String step, String dd) {
        String key = mf.format(new Object[]{step, dd}, new StringBuffer(), (FieldPosition)null).toString();
        return key.toLowerCase();
    }

    private String createKey(String step) {
        String key = mf4search.format(new Object[]{step}, new StringBuffer(), (FieldPosition)null).toString();
        return key.toLowerCase();
    }

    public String toString() {
        return this.mapDataDescription.toString();
    }
}

