/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.managers;

import java.util.Map;
import org.pepstock.jem.springbatch.JemBean;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.items.DataDescriptionItem;
import org.pepstock.jem.springbatch.tasks.JemTasklet;
import org.pepstock.jem.springbatch.tasks.managers.Definition;
import org.pepstock.jem.springbatch.tasks.managers.DefinitionsContainer;
import org.springframework.batch.core.Step;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.context.ConfigurableApplicationContext;

public class DefinitionsLoader {
    private static final String TASKLETS = "tasklet";
    private static final String CHUNKS = "hasChunkElement";
    private static final String ITEM_READER = "itemReader";
    private static final String ITEM_WRITER = "itemWriter";
    private static DefinitionsLoader INSTANCE = null;
    protected ConfigurableApplicationContext context = null;
    private String lockingScope = "job";

    private DefinitionsLoader() {
    }

    public static DefinitionsLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefinitionsLoader();
        }
        return INSTANCE;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ConfigurableApplicationContext context) {
        this.context = context;
        JemBean bean = (JemBean)context.getBean("jem.bean");
        if (bean.getLockingScope() != null) {
            if (!bean.getLockingScope().equalsIgnoreCase("job") && !bean.getLockingScope().equalsIgnoreCase("step")) {
                throw new RuntimeException(SpringBatchMessage.JEMS021E.toMessage().getFormattedMessage(bean.getLockingScope()));
            }
            this.lockingScope = bean.getLockingScope();
        } else {
            this.lockingScope = "job";
        }
        System.out.println(SpringBatchMessage.JEMS022I.toMessage().getFormattedMessage(bean.getJobName(), this.lockingScope));
    }

    public boolean isJobLockingScope() {
        return this.lockingScope.equalsIgnoreCase("job");
    }

    public boolean isStepLockingScope() {
        return this.lockingScope.equalsIgnoreCase("step");
    }

    public void loadForLock() {
        Map map = this.context.getBeansOfType(Step.class);
        if (!map.isEmpty()) {
            for (Object keyObject : map.keySet()) {
                String step = keyObject.toString();
                this.loadForLock(step);
            }
        }
    }

    public void loadForLock(String step) {
        BeanDefinition bDef = this.context.getBeanFactory().getBeanDefinition(step);
        if (bDef.getPropertyValues().contains(TASKLETS)) {
            RuntimeBeanReference task;
            Object object;
            PropertyValue property = bDef.getPropertyValues().getPropertyValue(TASKLETS);
            if (property.getValue() instanceof RuntimeBeanReference && (object = this.context.getBean((task = (RuntimeBeanReference)property.getValue()).getBeanName())) instanceof JemTasklet) {
                JemTasklet tasklet = (JemTasklet)object;
                Definition tasn = new Definition();
                tasn.setStepName(step);
                tasn.setObject(tasklet);
                DefinitionsContainer.getInstance().getObjects().add(tasn);
            }
        } else if (bDef.getPropertyValues().contains(CHUNKS)) {
            Definition tasn;
            DataDescriptionItem item;
            RuntimeBeanReference task;
            Object object;
            PropertyValue property;
            if (bDef.getPropertyValues().contains(ITEM_READER) && (property = bDef.getPropertyValues().getPropertyValue(ITEM_READER)).getValue() instanceof RuntimeBeanReference && (object = this.context.getBean((task = (RuntimeBeanReference)property.getValue()).getBeanName())) instanceof DataDescriptionItem) {
                item = (DataDescriptionItem)object;
                tasn = new Definition();
                tasn.setStepName(step);
                tasn.setObject(item);
                DefinitionsContainer.getInstance().getObjects().add(tasn);
            }
            if (bDef.getPropertyValues().contains(ITEM_WRITER) && (property = bDef.getPropertyValues().getPropertyValue(ITEM_WRITER)).getValue() instanceof RuntimeBeanReference && (object = this.context.getBean((task = (RuntimeBeanReference)property.getValue()).getBeanName())) instanceof DataDescriptionItem) {
                item = (DataDescriptionItem)object;
                tasn = new Definition();
                tasn.setStepName(step);
                tasn.setObject(item);
                DefinitionsContainer.getInstance().getObjects().add(tasn);
            }
        }
    }
}

