/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.managers;

import java.io.File;
import java.io.PrintStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.pepstock.jem.springbatch.tasks.managers.FileWrapper;

public class DataSetManager {
    public static final String INLINE_FILE_NAME_PREFIX = "step-inline";

    public static void createDataSetImpl(DataDescriptionImpl ddImpl, DataSet ds) throws Exception {
        DataSetImpl dataset = ds.getDataSetImpl();
        if (ds.isTemporary()) {
            if (!ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                throw new Exception(SpringBatchMessage.JEMS007E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
            }
            DataSetManager.createDataSetImpl(ds);
        } else if (ds.isInline()) {
            DataSetManager.createDataSetImpl(ds);
        } else if (ds.isGdg()) {
            if (ds.getName() == null) {
                throw new Exception(SpringBatchMessage.JEMS008E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            DataSetManager.createDataSetImpl(ds);
        } else if (ds.isDefinedDatasource()) {
            if (ds.getName() == null) {
                throw new Exception(SpringBatchMessage.JEMS008E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            DataSetManager.createDataSetImpl(ds);
        } else {
            if (ds.getName() == null) {
                throw new Exception(SpringBatchMessage.JEMS008E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
            DataSetManager.createDataSetImpl(ds);
            File file = dataset.getFile();
            if (ddImpl.getDisposition().equalsIgnoreCase("NEW")) {
                boolean isCreated;
                if (file.exists()) {
                    throw new Exception(SpringBatchMessage.JEMS009E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition(), ds.toString()));
                }
                File parent = file.getParentFile();
                if (!parent.exists() && !(isCreated = parent.mkdirs())) {
                    throw new Exception(NodeMessage.JEMC153E.toMessage().getFormattedMessage(parent.getAbsolutePath()));
                }
            } else if (!file.exists()) {
                throw new Exception(SpringBatchMessage.JEMS009E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
            }
        }
        ddImpl.addDataSetImpl(dataset);
    }

    public static void createDataSetImpl(DataSet ds) throws Exception {
        DataSetImpl dataset = ds.getDataSetImpl();
        if (ds.isTemporary()) {
            File file = File.createTempFile(ds.getName().substring(2), ".tmp");
            file.deleteOnExit();
            dataset.setFile(file);
            dataset.setType(1);
            dataset.setName(ds.getName());
        } else if (ds.isInline()) {
            File file = File.createTempFile(INLINE_FILE_NAME_PREFIX, ".tmp");
            file.deleteOnExit();
            PrintStream ps = new PrintStream(file);
            ps.print(ds.getText());
            ps.close();
            dataset.setFile(file);
            dataset.setType(2);
            dataset.setName(ds.getName());
        } else if (ds.isGdg()) {
            FileWrapper fileWrapper = DataSetManager.getFile(ds);
            File file = fileWrapper.getFile();
            dataset.setName(fileWrapper.getDataSetName());
            dataset.setType(4);
            dataset.setFile(file);
            dataset.setOffset(ds.getOffset());
        } else if (ds.isDefinedDatasource()) {
            dataset.setType(6);
            dataset.setDataSource(ds.getDatasource());
            dataset.setName(ds.getName());
        } else {
            FileWrapper fileWrapper = DataSetManager.getFile(ds);
            File file = fileWrapper.getFile();
            dataset.setName(fileWrapper.getDataSetName());
            dataset.setType(0);
            dataset.setFile(file);
        }
    }

    private static FileWrapper getFile(DataSet ds) throws Exception {
        String dataPath = System.getProperty("jem.data");
        if (dataPath == null) {
            throw new Exception(SpringBatchMessage.JEMS001E.toMessage().getFormattedMessage(new Object[0]));
        }
        dataPath = FilenameUtils.normalize((String)dataPath, (boolean)true);
        File file = null;
        String fileName = null;
        if (ds.getName().startsWith(dataPath)) {
            file = new File(ds.getName());
            fileName = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
            dataPath = FilenameUtils.normalize((String)dataPath, (boolean)true);
            fileName = StringUtils.substringAfter((String)fileName, (String)dataPath);
            fileName = fileName.substring(1);
        } else {
            file = new File(ds.getName());
            if (FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true).equalsIgnoreCase(ds.getName())) {
                fileName = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
            } else {
                file = new File(dataPath, ds.getName());
                fileName = FilenameUtils.normalize((String)ds.getName(), (boolean)true);
            }
        }
        return new FileWrapper(file, fileName);
    }
}

