/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks.managers;

import java.io.File;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.pepstock.jem.springbatch.tasks.managers.DataSetManager;
import org.pepstock.jem.springbatch.tasks.managers.ImplementationsContainer;

public class DataDescriptionManager {
    public static DataDescriptionImpl createDataDescriptionImpl(DataDescription dd, String stepName) throws Exception {
        if (dd.getName() == null) {
            throw new Exception(SpringBatchMessage.JEMS003E.toMessage().getFormattedMessage(new Object[0]));
        }
        DataDescriptionImpl ddImpl = new DataDescriptionImpl();
        ddImpl.setName(dd.getName());
        ddImpl.setDisposition(dd.getDisposition());
        if (dd.isSysout()) {
            DataDescriptionManager.loadSysout(ddImpl, stepName);
        } else if (dd.isSingleDataset()) {
            DataDescriptionManager.loadSingleDataset(ddImpl, dd, stepName);
        } else if (dd.isMultiDataset()) {
            DataDescriptionManager.loadMultiDataset(ddImpl, dd, stepName);
        }
        return ddImpl;
    }

    private static void loadSysout(DataDescriptionImpl ddImpl, String stepName) throws Exception {
        boolean isCreated;
        ddImpl.setSysout(true);
        String path = System.getProperty("jem.output");
        if (path == null) {
            throw new Exception(SpringBatchMessage.JEMS005E.toMessage().getFormattedMessage(new Object[0]));
        }
        File dir = new File(path, stepName);
        if (!dir.exists() && !(isCreated = dir.mkdir())) {
            throw new Exception(NodeMessage.JEMC153E.toMessage().getFormattedMessage(dir.getAbsolutePath()));
        }
        File file = new File(dir, stepName + "-" + ddImpl.getName() + ".log");
        DataSet ds = new DataSet();
        ds.setName(stepName + "-" + ddImpl.getName());
        DataSetImpl dataset = ds.getDataSetImpl();
        dataset.setName(file.getName());
        dataset.setType(5);
        dataset.setFile(file);
        ddImpl.addDataSetImpl(dataset);
        ImplementationsContainer.getInstance().addDataDescription(stepName, ddImpl);
    }

    private static void loadSingleDataset(DataDescriptionImpl ddImpl, DataDescription dd, String stepName) throws Exception {
        DataSet ds = dd.getDatasets().get(0);
        DataSetManager.createDataSetImpl(ddImpl, ds);
        ImplementationsContainer.getInstance().addDataDescription(stepName, ddImpl);
    }

    private static void loadMultiDataset(DataDescriptionImpl ddImpl, DataDescription dd, String stepName) throws Exception {
        if (!ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
            throw new Exception(SpringBatchMessage.JEMS005E.toMessage().getFormattedMessage(ddImpl.getName(), ddImpl.getDisposition()));
        }
        for (DataSet ds : dd.getDatasets()) {
            DataSetManager.createDataSetImpl(ddImpl, ds);
        }
        ImplementationsContainer.getInstance().addDataDescription(stepName, ddImpl);
    }
}

