/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks;

import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.util.Collection;
import org.pepstock.jem.Step;
import org.pepstock.jem.node.rmi.TasksDoor;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.SpringBatchSecurityManager;
import org.pepstock.jem.springbatch.tasks.managers.DefinitionsLoader;
import org.pepstock.jem.springbatch.tasks.managers.Locker;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.rmi.RegistryLocator;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class StepListener
implements StepExecutionListener,
JobExecutionListener,
ApplicationContextAware {
    private TasksDoor door = null;
    private Locker locker = null;
    private boolean isFirst = true;

    public StepListener() {
        try {
            this.locker = new Locker();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterJob(JobExecution arg0) {
        System.out.flush();
        System.err.flush();
        if (DefinitionsLoader.getInstance().isJobLockingScope()) {
            try {
                this.locker.unlock();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.door.setJobEnded();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        if (this.door == null) {
            String port = System.getProperty("jem.rmi.port");
            try {
                Collection<Role> myroles;
                RegistryLocator locator = new RegistryLocator(Parser.parseInt(port, -1));
                if (locator.hasRmiObject("TASKS_DOOR")) {
                    this.door = (TasksDoor)locator.getRmiObject("TASKS_DOOR");
                    myroles = this.door.setJobStarted(ManagementFactory.getRuntimeMXBean().getName());
                    if (System.getSecurityManager() != null) {
                        throw new Exception(SpringBatchMessage.JEMS027E.toMessage().getMessage());
                    }
                } else {
                    throw new Exception(SpringBatchMessage.JEMS026E.toMessage().getFormattedMessage("TASKS_DOOR"));
                }
                System.setSecurityManager(new SpringBatchSecurityManager(myroles));
            }
            catch (Exception e) {
                throw new RuntimeException(SpringBatchMessage.JEMS028E.toMessage().getFormattedMessage(jobExecution.getJobInstance().getJobName()), e);
            }
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        if (DefinitionsLoader.getInstance().isStepLockingScope()) {
            try {
                this.locker.unlock();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Step step = new Step();
            step.setName(stepExecution.getStepName());
            step.setDescritpion(stepExecution.getSummary());
            ExitStatus eStatus = stepExecution.getExitStatus();
            if (eStatus.equals((Object)ExitStatus.COMPLETED)) {
                step.setReturnCode(0);
            } else {
                step.setReturnCode(1);
                step.setException(stepExecution.getFailureExceptions().toString());
            }
            this.door.setStepEnded(step);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        if (this.isFirst) {
            if (DefinitionsLoader.getInstance().isJobLockingScope()) {
                DefinitionsLoader.getInstance().loadForLock();
                try {
                    this.locker.lock();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.isFirst = false;
        }
        if (DefinitionsLoader.getInstance().isStepLockingScope()) {
            DefinitionsLoader.getInstance().loadForLock(stepExecution.getStepName());
            try {
                this.locker.lock();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Step step = new Step();
            step.setName(stepExecution.getStepName());
            step.setDescritpion(stepExecution.getSummary());
            this.door.setStepStarted(step);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        DefinitionsLoader.getInstance().setContext((ConfigurableApplicationContext)context);
    }
}

