/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks;

import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.Collection;
import java.util.PropertyPermission;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.BatchSecurityManager;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.Parser;

public class SpringBatchSecurityManager
extends BatchSecurityManager {
    private boolean isAdministrator = false;
    private boolean isGrantor = false;
    private boolean internalAction = true;

    public SpringBatchSecurityManager(Collection<Role> roles) {
        super(roles);
        this.loadPermissions(roles);
    }

    boolean isInternalAction() {
        return this.internalAction;
    }

    void setInternalAction(boolean internalAction) {
        this.internalAction = internalAction;
    }

    boolean isAdministrator() {
        return this.isAdministrator;
    }

    void setAdministrator(boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
    }

    boolean isGrantor() {
        return this.isGrantor;
    }

    void setGrantor(boolean isGrantor) {
        this.isGrantor = isGrantor;
    }

    private void loadPermissions(Collection<Role> roles) {
        for (Role role : roles) {
            if (role.getName().equalsIgnoreCase("administrator")) {
                this.setAdministrator(true);
            }
            if (!role.getName().equalsIgnoreCase("grantor")) continue;
            this.setGrantor(true);
        }
    }

    @Override
    public final boolean checkBatchPermission(String permission) {
        if (this.isAdministrator() || this.isInternalAction()) {
            return true;
        }
        return super.checkBatchPermission(permission);
    }

    @Override
    public void checkPermission(Permission perm) {
        int portRmi;
        SocketPermission sperm;
        int port;
        if (perm instanceof PropertyPermission && perm.getActions() != null && perm.getActions().equalsIgnoreCase("write") && perm.getName().startsWith("jem")) {
            System.out.println(NodeMessage.JEMC127E.toMessage().getMessage());
            throw new SecurityException(NodeMessage.JEMC127E.toMessage().getMessage());
        }
        if (this.isAdministrator() || this.isInternalAction()) {
            return;
        }
        if (perm instanceof FilePermission) {
            if (perm.getActions() != null) {
                if (perm.getActions().equalsIgnoreCase("read")) {
                    this.checkRead(perm.getName());
                } else if (perm.getActions().equalsIgnoreCase("write")) {
                    this.checkWrite(perm.getName());
                } else if (perm.getActions().equalsIgnoreCase("delete")) {
                    this.checkDelete(perm.getName());
                }
            } else {
                this.checkRead(perm.getName());
            }
        } else if (perm instanceof SocketPermission && (port = Parser.parseInt(StringUtils.substringAfter((String)(sperm = (SocketPermission)perm).getName(), (String)":"), Integer.MAX_VALUE)) == (portRmi = Parser.parseInt(System.getProperty("jem.rmi.port"), Integer.MIN_VALUE)) && !this.isInternalAction() && !this.isGrantor()) {
            String hostname = StringUtils.substringBefore((String)sperm.getName(), (String)":");
            try {
                String resolved = InetAddress.getByName(hostname).getHostAddress();
                String localhost = InetAddress.getLocalHost().getHostAddress();
                if (resolved.equalsIgnoreCase(localhost) && !this.checkBatchPermission("internal_services")) {
                    System.out.println(NodeMessage.JEMC128E.toMessage().getMessage());
                    throw new SecurityException(NodeMessage.JEMC128E.toMessage().getMessage());
                }
            }
            catch (UnknownHostException e) {
                System.out.println(NodeMessage.JEMC128E.toMessage().getMessage());
                throw new SecurityException(NodeMessage.JEMC128E.toMessage().getMessage());
            }
        }
    }

    @Override
    public final void checkRead(String file) {
        if (this.isAdministrator() || this.isInternalAction()) {
            return;
        }
        super.checkRead(file);
    }

    @Override
    public void checkWrite(String file) {
        if (this.isAdministrator() || this.isInternalAction()) {
            return;
        }
        super.checkWrite(file);
    }
}

